/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio.icon;

import com.android.tools.idea.npw.assetstudio.icon.AndroidActionBarIconGenerator;
import com.android.tools.idea.npw.assetstudio.icon.AndroidIconGenerator;
import com.android.tools.idea.npw.assetstudio.icon.AndroidLauncherIconGenerator;
import com.android.tools.idea.npw.assetstudio.icon.AndroidNotificationIconGenerator;
import org.jetbrains.annotations.NotNull;

public enum AndroidIconType {
    LAUNCHER("Launcher Icons", "ic_launcher"),
    ACTIONBAR("Action Bar and Tab Icons", "ic_action_%s"),
    NOTIFICATION("Notification Icons", "ic_stat_%s");

    @NotNull
    private final String myDisplayName;
    @NotNull
    private final String myDefaultNameFormat;

    private AndroidIconType(String displayName, String defaultNameFormat) {
        this.myDisplayName = displayName;
        this.myDefaultNameFormat = defaultNameFormat;
    }

    @NotNull
    public static AndroidIconGenerator createIconGenerator(@NotNull AndroidIconType iconType) {
        switch (iconType) {
            case LAUNCHER: {
                return new AndroidLauncherIconGenerator();
            }
            case ACTIONBAR: {
                return new AndroidActionBarIconGenerator();
            }
            case NOTIFICATION: {
                return new AndroidNotificationIconGenerator();
            }
        }
        throw new IllegalArgumentException("Can't create generator for unexpected icon type: " + (Object)((Object)iconType));
    }

    @NotNull
    public String getDisplayName() {
        return this.myDisplayName;
    }

    @NotNull
    public String toOutputName(@NotNull String baseName) {
        return String.format(this.myDefaultNameFormat, baseName);
    }

    @NotNull
    public String toString() {
        return this.getDisplayName();
    }
}

