/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio.assets;

import com.android.assetstudiolib.TextRenderUtil;
import com.android.tools.idea.npw.assetstudio.assets.BaseAsset;
import com.android.tools.idea.ui.properties.core.IntProperty;
import com.android.tools.idea.ui.properties.core.IntValueProperty;
import com.android.tools.idea.ui.properties.core.StringProperty;
import com.android.tools.idea.ui.properties.core.StringValueProperty;
import com.google.common.collect.Lists;
import java.awt.Color;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class TextAsset
extends BaseAsset {
    private static final String PREFERRED_FONT = "Roboto";
    private final StringProperty myText = new StringValueProperty("Aa");
    private final StringProperty myFontFamily = new StringValueProperty();
    private final IntProperty myFontSize = new IntValueProperty(144);

    public TextAsset() {
        List<String> fontFamilies = TextAsset.getAllFontFamilies();
        assert (fontFamilies.size() > 0);
        if (fontFamilies.contains(PREFERRED_FONT)) {
            this.myFontFamily.set(PREFERRED_FONT);
        } else {
            this.myFontFamily.set(fontFamilies.get(0));
        }
    }

    @NotNull
    public static List<String> getAllFontFamilies() {
        return Lists.newArrayList((Object[])GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames());
    }

    @NotNull
    public StringProperty text() {
        return this.myText;
    }

    @NotNull
    public StringProperty fontFamily() {
        return this.myFontFamily;
    }

    @Override
    @NotNull
    protected BufferedImage createAsImage(@NotNull Color color) {
        TextRenderUtil.Options options = new TextRenderUtil.Options();
        options.font = Font.decode(this.myFontFamily + " " + this.myFontSize.get());
        options.foregroundColor = color.getRGB();
        return TextRenderUtil.renderTextImage((String)((String)this.myText.get()), (int)1, (TextRenderUtil.Options)options);
    }
}

