/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio;

import com.android.ide.common.util.AssetUtil;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.idea.npw.project.AndroidProjectPaths;
import com.android.tools.idea.rendering.ImageUtils;
import com.android.tools.idea.res.AppResourceRepository;
import com.intellij.openapi.util.io.FileUtil;
import java.awt.image.BufferedImage;
import java.io.File;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public final class AssetStudioUtils {
    @NotNull
    public static BufferedImage createDummyImage() {
        return new BufferedImage(1, 1, 2);
    }

    @NotNull
    public static BufferedImage trim(@NotNull BufferedImage image) {
        BufferedImage cropped = ImageUtils.cropBlank(image, null, 2);
        return cropped != null ? cropped : image;
    }

    @NotNull
    public static BufferedImage pad(@NotNull BufferedImage image, int paddingPercent) {
        if (image.getWidth() <= 1 || image.getHeight() <= 1) {
            return image;
        }
        if (paddingPercent > 100) {
            paddingPercent = 100;
        }
        int largerSide = Math.max(image.getWidth(), image.getHeight());
        int smallerSide = Math.min(image.getWidth(), image.getHeight());
        int padding = largerSide * paddingPercent / 100;
        padding = Math.max(-(smallerSide / 2 - 1), padding);
        return AssetUtil.paddedImage((BufferedImage)image, (int)padding);
    }

    public static boolean resourceExists(@NotNull AndroidProjectPaths paths, @NotNull ResourceFolderType resourceType, @NotNull String name) {
        File resDir = paths.getResDirectory();
        if (resDir == null) {
            return false;
        }
        File[] resTypes = resDir.listFiles();
        if (resTypes == null) {
            return false;
        }
        for (File resTypeDir : resTypes) {
            File[] files;
            if (!resTypeDir.isDirectory() || !resourceType.equals((Object)ResourceFolderType.getFolderType((String)resTypeDir.getName())) || (files = resTypeDir.listFiles()) == null) continue;
            for (File f : files) {
                if (!FileUtil.getNameWithoutExtension((File)f).equalsIgnoreCase(name)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean resourceExists(@NotNull AndroidFacet facet, @NotNull ResourceType resourceType, @NotNull String name) {
        AppResourceRepository repository = facet.getAppResources(true);
        return repository.hasResourceItem(resourceType, name);
    }

    private AssetStudioUtils() {
    }
}

