/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio;

import com.android.assetstudiolib.GraphicGenerator;
import com.android.assetstudiolib.GraphicGeneratorContext;
import com.android.tools.idea.npw.assetstudio.AssetStudioUtils;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.intellij.openapi.diagnostic.Logger;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.jetbrains.annotations.NotNull;

public final class AssetStudioGraphicGeneratorContext
implements GraphicGeneratorContext {
    private static Cache<String, BufferedImage> ourImageCache = CacheBuilder.newBuilder().build();

    private static Logger getLog() {
        return Logger.getInstance(AssetStudioGraphicGeneratorContext.class);
    }

    @NotNull
    private static BufferedImage getStencilImage(@NotNull String path) throws IOException {
        BufferedImage image = GraphicGenerator.getStencilImage((String)path);
        if (image == null) {
            image = AssetStudioUtils.createDummyImage();
        }
        return image;
    }

    public BufferedImage loadImageResource(final @NotNull String path) {
        try {
            return (BufferedImage)ourImageCache.get((Object)path, (Callable)new Callable<BufferedImage>(){

                @Override
                public BufferedImage call() throws Exception {
                    return AssetStudioGraphicGeneratorContext.getStencilImage(path);
                }
            });
        }
        catch (ExecutionException e) {
            AssetStudioGraphicGeneratorContext.getLog().error((Throwable)e);
            return null;
        }
    }
}

