/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw;

import com.android.repository.io.FileOpUtils;
import com.android.tools.idea.gradle.project.GradleProjectImporter;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.npw.FormFactor;
import com.android.tools.idea.npw.FormFactorUtils;
import com.android.tools.idea.npw.PostStartupGradleSyncListener;
import com.android.tools.idea.npw.cpp.ConfigureCppSupportPath;
import com.android.tools.idea.npw.deprecated.ConfigureAndroidProjectPath;
import com.android.tools.idea.npw.deprecated.NewFormFactorModulePath;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.startup.AndroidStudioInitializer;
import com.android.tools.idea.templates.KeystoreUtils;
import com.android.tools.idea.templates.RepositoryUrlManager;
import com.android.tools.idea.templates.SupportLibrary;
import com.android.tools.idea.templates.TemplateManager;
import com.android.tools.idea.templates.TemplateUtils;
import com.android.tools.idea.wizard.WizardConstants;
import com.android.tools.idea.wizard.dynamic.DynamicWizard;
import com.android.tools.idea.wizard.dynamic.DynamicWizardHost;
import com.android.tools.idea.wizard.dynamic.ScopedStateStore;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiFile;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NewProjectWizardDynamic
extends DynamicWizard {
    private static final String ERROR_MSG_TITLE = "Error in New Project Wizard";
    private Project myProject;

    public NewProjectWizardDynamic(@Nullable Project project, @Nullable Module module) {
        super(project, module, "New Project");
        this.setTitle("Create New Project");
    }

    public NewProjectWizardDynamic(@Nullable Project project, @Nullable Module module, @NotNull DynamicWizardHost host) {
        super(project, module, "New Project", host);
        this.setTitle("Create New Project");
    }

    @Override
    public void init() {
        this.checkSdk();
        this.addPaths();
        this.initState();
        super.init();
    }

    protected void checkSdk() {
        if (!AndroidSdkUtils.isAndroidSdkAvailable() || !TemplateManager.templatesAreValid()) {
            String title = "SDK problem";
            String msg = "<html>Your Android SDK is missing, out of date, or is missing templates.<br>You can configure your SDK via <b>Configure | Project Defaults | Project Structure | SDKs</b></html>";
            Messages.showErrorDialog((String)msg, (String)title);
            throw new IllegalStateException("Android SDK missing");
        }
    }

    private void addPaths() {
        this.addPath(new ConfigureAndroidProjectPath(this.getDisposable()));
        for (NewFormFactorModulePath path : NewFormFactorModulePath.getAvailableFormFactorModulePaths(this.getDisposable())) {
            this.addPath(path);
        }
        this.addPath(new ConfigureCppSupportPath(this.getDisposable()));
    }

    private void initState() {
        NewProjectWizardDynamic.initState(this.getState(), "2.2.2");
    }

    static void initState(@NotNull ScopedStateStore state, @NotNull String gradlePluginVersion) {
        AndroidSdkData data;
        state.put(WizardConstants.GRADLE_PLUGIN_VERSION_KEY, gradlePluginVersion);
        state.put(WizardConstants.GRADLE_VERSION_KEY, "2.14.1");
        state.put(WizardConstants.IS_GRADLE_PROJECT_KEY, true);
        state.put(WizardConstants.IS_NEW_PROJECT_KEY, true);
        state.put(WizardConstants.TARGET_FILES_KEY, new HashSet());
        state.put(WizardConstants.FILES_TO_OPEN_KEY, new ArrayList());
        state.put(WizardConstants.USE_PER_MODULE_REPOS_KEY, false);
        try {
            state.put(WizardConstants.DEBUG_KEYSTORE_SHA_1_KEY, KeystoreUtils.sha1(KeystoreUtils.getOrCreateDefaultDebugKeystore()));
        }
        catch (Exception exception) {
            LOG.warn("Could not create debug keystore", (Throwable)exception);
            state.put(WizardConstants.DEBUG_KEYSTORE_SHA_1_KEY, "");
        }
        String mavenUrl = System.getProperty("android.mavenRepoUrl");
        if (mavenUrl != null) {
            state.put(WizardConstants.MAVEN_URL_KEY, mavenUrl);
        }
        if ((data = AndroidSdkUtils.tryToChooseAndroidSdk()) != null) {
            File sdkLocation = data.getLocation();
            state.put(WizardConstants.SDK_DIR_KEY, sdkLocation.getPath());
            String espressoVersion = RepositoryUrlManager.get().getLibraryRevision(SupportLibrary.ESPRESSO_CORE.getGroupId(), SupportLibrary.ESPRESSO_CORE.getArtifactId(), null, false, sdkLocation, FileOpUtils.create());
            if (espressoVersion != null) {
                state.put(WizardConstants.ESPRESSO_VERSION_KEY, espressoVersion);
            }
        }
    }

    @Override
    protected String getWizardActionDescription() {
        return String.format("Create %1$s", this.getState().get(WizardConstants.APPLICATION_NAME_KEY));
    }

    @Override
    public void performFinishingActions() {
        ApplicationManager.getApplication().invokeLater(this::runFinish);
    }

    private void runFinish() {
        Sdk jdk;
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        GradleProjectImporter projectImporter = GradleProjectImporter.getInstance();
        String rootPath = this.getState().get(WizardConstants.PROJECT_LOCATION_KEY);
        if (rootPath == null) {
            LOG.error("No root path specified for project");
            return;
        }
        File rootLocation = new File(rootPath);
        File wrapperPropertiesFilePath = GradleUtil.getGradleWrapperPropertiesFilePath(rootLocation);
        try {
            GradleUtil.updateGradleDistributionUrl("2.14.1", wrapperPropertiesFilePath);
        }
        catch (IOException e) {
            LOG.warn("Failed to update Gradle wrapper file", (Throwable)e);
        }
        String projectName = this.getState().get(WizardConstants.APPLICATION_NAME_KEY);
        if (projectName == null) {
            projectName = "Unnamed Project";
        }
        LanguageLevel initialLanguageLevel = null;
        Iterator<FormFactor> iterator = FormFactor.iterator();
        while (iterator.hasNext()) {
            LanguageLevel level;
            FormFactor factor = iterator.next();
            String version = this.getState().get(FormFactorUtils.getLanguageLevelKey(factor));
            if (version == null || (level = LanguageLevel.parse((String)version.toString())) == null || initialLanguageLevel != null && !level.isAtLeast(initialLanguageLevel)) continue;
            initialLanguageLevel = level;
        }
        if (!AndroidStudioInitializer.isAndroidStudio() && (jdk = IdeSdks.getJdk()) != null) {
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    ProjectRootManager.getInstance((Project)NewProjectWizardDynamic.this.myProject).setProjectSdk(jdk);
                }
            });
        }
        try {
            PostStartupGradleSyncListener listener = new PostStartupGradleSyncListener(new Runnable(){

                @Override
                public void run() {
                    Iterable targetFiles = NewProjectWizardDynamic.this.myState.get(WizardConstants.TARGET_FILES_KEY);
                    assert (targetFiles != null);
                    TemplateUtils.reformatAndRearrange(NewProjectWizardDynamic.this.myProject, targetFiles);
                    Collection filesToOpen = NewProjectWizardDynamic.this.myState.get(WizardConstants.FILES_TO_OPEN_KEY);
                    assert (filesToOpen != null);
                    TemplateUtils.openEditors(NewProjectWizardDynamic.this.myProject, filesToOpen, true);
                }
            });
            projectImporter.importNewlyCreatedProject(projectName, rootLocation, listener, this.myProject, initialLanguageLevel);
        }
        catch (IOException e) {
            Messages.showErrorDialog((String)e.getMessage(), (String)ERROR_MSG_TITLE);
            LOG.error((Throwable)e);
        }
        catch (ConfigurationException e) {
            Messages.showErrorDialog((String)e.getMessage(), (String)ERROR_MSG_TITLE);
            LOG.error((Throwable)e);
        }
    }

    @Override
    @NotNull
    protected String getProgressTitle() {
        return "Creating project...";
    }

    @Override
    protected void doFinish() throws IOException {
        final String location = this.myState.get(WizardConstants.PROJECT_LOCATION_KEY);
        final String name = this.myState.get(WizardConstants.APPLICATION_NAME_KEY);
        assert (location != null && name != null);
        new WriteCommandAction.Simple(this.getProject(), new PsiFile[0]){

            protected void run() throws Throwable {
                VfsUtil.createDirectoryIfMissing((String)location);
            }
        }.execute();
        this.myProject = (Project)UIUtil.invokeAndWaitIfNeeded((Computable)new Computable<Project>(){

            public Project compute() {
                return ProjectManager.getInstance().createProject(name, location);
            }
        });
        super.doFinish();
    }

    @Override
    @Nullable
    public Project getProject() {
        return this.myProject;
    }
}

