/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw;

import com.android.builder.model.SourceProvider;
import com.android.tools.idea.npw.AddAndroidActivityPath;
import com.android.tools.idea.npw.CreateModuleTemplate;
import com.android.tools.idea.npw.ModuleTemplate;
import com.android.tools.idea.npw.NewModuleDynamicPath;
import com.android.tools.idea.npw.TemplateEntry;
import com.android.tools.idea.npw.TemplateParameterStep2;
import com.android.tools.idea.npw.WizardUtils;
import com.android.tools.idea.templates.Template;
import com.android.tools.idea.templates.TemplateManager;
import com.android.tools.idea.templates.TemplateMetadata;
import com.android.tools.idea.templates.recipe.RenderingContext;
import com.android.tools.idea.wizard.WizardConstants;
import com.android.tools.idea.wizard.dynamic.DynamicWizardPath;
import com.android.tools.idea.wizard.dynamic.ScopedStateStore;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LanguageLevelModuleExtensionImpl;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.pom.java.LanguageLevel;
import icons.AndroidIcons;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class JavaModuleDynamicPath
extends DynamicWizardPath
implements NewModuleDynamicPath {
    public static final String JAVA_LIBRARY = "Java Library";
    private static final ScopedStateStore.Key<String> SRC_DIR = ScopedStateStore.createKey("srcDir", ScopedStateStore.Scope.PATH, String.class);
    private static final ScopedStateStore.Key<String> PACKAGE_NAME = ScopedStateStore.createKey("packageName", ScopedStateStore.Scope.PATH, String.class);
    @NotNull
    private final Disposable myDisposable;
    private final TemplateMetadata myMetadata;
    private final Template myTemplate;
    private CreateModuleTemplate myModuleTemplate;

    public JavaModuleDynamicPath(@NotNull Disposable disposable) {
        this.myDisposable = disposable;
        TemplateManager instance = TemplateManager.getInstance();
        this.myMetadata = instance.getTemplateMetadata("Application", JAVA_LIBRARY);
        assert (this.myMetadata != null);
        File templateFile = instance.getTemplateFile("Application", JAVA_LIBRARY);
        assert (templateFile != null);
        this.myTemplate = Template.createFromPath(templateFile);
        this.myModuleTemplate = new CreateModuleTemplate(this.myMetadata, null, this.myMetadata.getTitle(), AndroidIcons.ModuleTemplates.Android);
    }

    @Override
    protected void init() {
        TemplateParameterStep2 parameterStep = new TemplateParameterStep2(null, (Map)ImmutableMap.of(), this.myDisposable, PACKAGE_NAME, new SourceProvider[0], JAVA_LIBRARY){

            @Override
            public boolean isStepVisible() {
                return true;
            }
        };
        this.addStep(parameterStep);
        this.myState.put(AddAndroidActivityPath.KEY_SELECTED_TEMPLATE, new TemplateEntry(this.myTemplate.getRootPath(), this.myMetadata));
        this.myState.put(SRC_DIR, "src/main/java");
        this.put("resDir", "src/main/res");
        this.put("aidlDir", "src/main/aidl");
        this.put("manifestDir", "src/main");
        this.put("testDir", "src/androidTest");
    }

    private void put(String attr, String value) {
        ScopedStateStore.Key<String> key = ScopedStateStore.createKey(attr, ScopedStateStore.Scope.PATH, String.class);
        this.myState.put(key, value);
    }

    @Override
    public boolean isPathVisible() {
        return this.myModuleTemplate.equals(this.myState.get(WizardConstants.SELECTED_MODULE_TYPE_KEY));
    }

    @Override
    @NotNull
    public String getPathName() {
        return "New Java Module";
    }

    @Override
    public boolean canPerformFinishingActions() {
        return this.performFinishingOperation(true);
    }

    @Override
    public boolean performFinishingActions() {
        return this.performFinishingOperation(false);
    }

    private boolean performFinishingOperation(boolean dryRun) {
        final Project project = this.getProject();
        assert (project != null);
        HashMap parameterValueMap = Maps.newHashMap();
        parameterValueMap.putAll(this.myState.flatten());
        String projectName = (String)parameterValueMap.get("projectName");
        String moduleName = WizardUtils.computeModuleName(projectName, this.getProject());
        String modulePath = FileUtil.toSystemIndependentName((String)FileUtil.join((String[])new String[]{project.getBasePath(), moduleName}));
        parameterValueMap.put("projectOut", modulePath);
        parameterValueMap.put("projectName", moduleName);
        String packageName = this.myState.get(PACKAGE_NAME);
        assert (packageName != null);
        String packagePath = FileUtil.join((String[])new String[]{this.myState.getNotNull(SRC_DIR, "src/main/java/"), packageName.replace('.', '/')});
        String srcOut = FileUtil.toSystemIndependentName((String)FileUtil.join((String[])new String[]{modulePath, packagePath}));
        parameterValueMap.put("srcOut", srcOut);
        parameterValueMap.put("isNewProject", true);
        parameterValueMap.put("isLibraryProject", true);
        if (!parameterValueMap.containsKey("javaVersion")) {
            LanguageLevel min = (LanguageLevel)ApplicationManager.getApplication().runReadAction((Computable)new Computable<LanguageLevel>(){

                public LanguageLevel compute() {
                    LanguageLevel min = null;
                    for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
                        LanguageLevel moduleLevel;
                        LanguageLevelModuleExtensionImpl moduleLevelExt = LanguageLevelModuleExtensionImpl.getInstance((Module)module);
                        if (moduleLevelExt == null || (moduleLevel = moduleLevelExt.getLanguageLevel()) == null) continue;
                        if (min == null) {
                            min = moduleLevel;
                            continue;
                        }
                        if (moduleLevel.compareTo((Enum)min) >= 0) continue;
                        min = moduleLevel;
                    }
                    if (min == null) {
                        min = LanguageLevelProjectExtension.getInstance((Project)project).getLanguageLevel();
                    }
                    return min;
                }
            });
            parameterValueMap.put("javaVersion", min.getCompilerComplianceDefaultOption());
        }
        RenderingContext context = RenderingContext.Builder.newContext(this.myTemplate, project).withCommandName("New Java Library").withDryRun(dryRun).withShowErrors(true).withModuleRoot(new File(FileUtil.toSystemDependentName((String)modulePath))).withParams(parameterValueMap).withGradleSync(false).build();
        return this.myTemplate.render(context);
    }

    @Override
    @NotNull
    public Iterable<ModuleTemplate> getModuleTemplates() {
        return ImmutableSet.of((Object)this.myModuleTemplate);
    }
}

