/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw;

import com.android.tools.idea.npw.FormFactor;
import com.android.tools.idea.npw.FormFactorApiComboBox;
import com.android.tools.idea.npw.FormFactorSdkControls;
import com.android.tools.idea.npw.FormFactorUtils;
import com.android.tools.idea.templates.TemplateManager;
import com.android.tools.idea.templates.TemplateMetadata;
import com.android.tools.idea.wizard.WizardConstants;
import com.android.tools.idea.wizard.dynamic.DynamicWizardStepWithHeaderAndDescription;
import com.android.tools.idea.wizard.dynamic.ScopedStateStore;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.openapi.Disposable;
import com.intellij.ui.JBColor;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.AsyncProcessIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class ConfigureFormFactorStep
extends DynamicWizardStepWithHeaderAndDescription {
    public static final ScopedStateStore.Key<Integer> NUM_ENABLED_FORM_FACTORS_KEY = ScopedStateStore.createKey("NumberOfEnabledFormFactors", ScopedStateStore.Scope.WIZARD, Integer.class);
    private JPanel myPanel;
    private JPanel myFormFactorPanel;
    private JPanel myLoadingPanel;
    private final List<FormFactorSdkControls> myControls;
    private final Map<FormFactor, Integer> myFormFactors;
    private final Disposable myDisposable;
    private final Map<FormFactor, FormFactorSdkControls> myFormFactorApiSelectors;

    public ConfigureFormFactorStep(@NotNull Disposable disposable) {
        super("Select the form factors your app will run on", "Different platforms may require separate SDKs", disposable);
        this.$$$setupUI$$$();
        this.myControls = Lists.newArrayList();
        this.myFormFactors = Maps.newTreeMap();
        this.myFormFactorApiSelectors = Maps.newHashMap();
        this.myDisposable = disposable;
        this.setBodyComponent(this.myPanel);
        this.populateAdditionalFormFactors();
    }

    @Override
    public void init() {
        super.init();
        HashSet pendingControls = Sets.newHashSet(this.myControls);
        for (FormFactorSdkControls controls : this.myControls) {
            controls.init(this.myState, () -> {
                pendingControls.remove(controls);
                if (pendingControls.isEmpty()) {
                    this.myLoadingPanel.setVisible(false);
                }
            });
        }
        this.myState.put(this.myControls.get(0).getInclusionKey(), true);
    }

    private void populateAdditionalFormFactors() {
        TemplateManager manager = TemplateManager.getInstance();
        List<File> applicationTemplates = manager.getTemplatesInCategory("Application");
        this.myFormFactors.clear();
        this.myFormFactorPanel.removeAll();
        int row = 0;
        for (File templateFile : applicationTemplates) {
            TemplateMetadata metadata = manager.getTemplateMetadata(templateFile);
            if (metadata == null || metadata.getFormFactor() == null) continue;
            FormFactor formFactor = FormFactor.get(metadata.getFormFactor());
            Integer prevMinSdk = this.myFormFactors.get((Object)formFactor);
            int templateMinSdk = metadata.getMinSdk();
            if (prevMinSdk == null) {
                this.myFormFactors.put(formFactor, Math.max(templateMinSdk, formFactor.getMinOfflineApiLevel()));
                continue;
            }
            if (templateMinSdk <= prevMinSdk) continue;
            this.myFormFactors.put(formFactor, templateMinSdk);
        }
        GridLayoutManager gridLayoutManager = new GridLayoutManager(this.myFormFactors.size(), 1);
        gridLayoutManager.setVGap(5);
        gridLayoutManager.setHGap(10);
        this.myFormFactorPanel.setLayout((LayoutManager)gridLayoutManager);
        for (FormFactor formFactor : this.myFormFactors.keySet()) {
            GridConstraints c = new GridConstraints();
            c.setRow(row);
            c.setColumn(0);
            c.setFill(1);
            c.setAnchor(8);
            FormFactorSdkControls controls = new FormFactorSdkControls(formFactor, this.myFormFactors.get((Object)formFactor), this.myDisposable, this);
            this.myControls.add(controls);
            this.myFormFactorPanel.add((Component)controls.getComponent(), c);
            this.myFormFactorApiSelectors.put(formFactor, controls);
            ++row;
        }
    }

    @Override
    public void onEnterStep() {
        super.onEnterStep();
        if (this.myState.containsKey(WizardConstants.NEWLY_INSTALLED_API_KEY)) {
            FormFactorApiComboBox.loadInstalledVersions();
        }
    }

    @Override
    public void deriveValues(Set<ScopedStateStore.Key> modified) {
        super.deriveValues(modified);
        int enabledFormFactors = 0;
        for (FormFactor formFactor : this.myFormFactors.keySet()) {
            FormFactorSdkControls controls;
            boolean included = this.myState.getNotNull(FormFactorUtils.getInclusionKey(formFactor), false);
            if (included) {
                ++enabledFormFactors;
            }
            if ((controls = this.myFormFactorApiSelectors.get((Object)formFactor)) == null) continue;
            controls.deriveValues(this.myState, modified);
        }
        this.myState.put(NUM_ENABLED_FORM_FACTORS_KEY, enabledFormFactors);
    }

    @Override
    public boolean validate() {
        this.setErrorHtml("");
        Integer enabledFormFactors = this.myState.get(NUM_ENABLED_FORM_FACTORS_KEY);
        if (enabledFormFactors == null || enabledFormFactors < 1) {
            this.setErrorHtml("At least one form factor must be selected.");
            return false;
        }
        for (FormFactor formFactor : this.myFormFactors.keySet()) {
            Boolean included = this.myState.get(FormFactorUtils.getInclusionKey(formFactor));
            if (included == null || !included.booleanValue()) continue;
            if (!this.isBaseEnabled(formFactor)) {
                return false;
            }
            if (formFactor.baseFormFactor != null || this.myState.get(FormFactorUtils.getMinApiKey(formFactor)) != null) continue;
            this.setErrorHtml((Object)((Object)formFactor) + " must have a Minimum SDK level selected.");
            return false;
        }
        return true;
    }

    private boolean isBaseEnabled(FormFactor formFactor) {
        if (formFactor.baseFormFactor == null) {
            return true;
        }
        Boolean isBaseEnabled = this.myState.get(FormFactorUtils.getInclusionKey(formFactor.baseFormFactor));
        if (isBaseEnabled == null || !isBaseEnabled.booleanValue()) {
            this.setErrorHtml("In order to support " + (Object)((Object)formFactor) + " you need to enable " + (Object)((Object)formFactor.baseFormFactor));
            return false;
        }
        FormFactorApiComboBox.AndroidTargetComboBoxItem baseMinSdk = this.myState.get(FormFactorUtils.getTargetComboBoxKey(formFactor.baseFormFactor));
        if (!FormFactorUtils.getMinSdkComboBoxFilter(formFactor, this.myFormFactors.get((Object)formFactor)).apply((Object)baseMinSdk)) {
            this.setErrorHtml("Set a minimum SDK level on " + (Object)((Object)formFactor.baseFormFactor) + " that is compatible with " + (Object)((Object)formFactor));
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public String getStepName() {
        return "Configure Form Factors";
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myPanel;
    }

    @Override
    @NotNull
    protected DynamicWizardStepWithHeaderAndDescription.WizardStepHeaderSettings getStepHeader() {
        return DynamicWizardStepWithHeaderAndDescription.WizardStepHeaderSettings.createTitleOnlyHeader("Target Android Devices");
    }

    private void createUIComponents() {
        this.myLoadingPanel = new JPanel(new FlowLayout(0));
        AsyncProcessIcon refreshIcon = new AsyncProcessIcon("loading");
        JLabel refreshingLabel = new JLabel("Looking for SDKs available for download...");
        refreshingLabel.setForeground((Color)JBColor.GRAY);
        this.myLoadingPanel.add((Component)refreshIcon);
        this.myLoadingPanel.add(refreshingLabel);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        this.createUIComponents();
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 3, new Insets(0, 5, 5, 5), -1, -1, false, false));
        this.myFormFactorPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, new Dimension(750, -1), new Dimension(750, -1)));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(0, 0, 1, 1, 0, 1, 7, 1, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(0, 2, 1, 1, 0, 1, 7, 1, null, null, null));
        JPanel jPanel3 = this.myLoadingPanel;
        jPanel2.add((Component)jPanel3, new GridConstraints(1, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel2.add((Component)spacer3, new GridConstraints(1, 0, 2, 1, 0, 2, 1, 6, null, null, null));
    }

    @Override
    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

