/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw;

import com.intellij.openapi.application.Application;
import org.jetbrains.annotations.NotNull;

public abstract class AsyncValidator<V> {
    @NotNull
    private final Application myApplication;
    private final ResultReporter myResultReporter = new ResultReporter();
    private boolean myIsDirty = false;
    private boolean myIsScheduled = false;

    public AsyncValidator(@NotNull Application application) {
        this.myApplication = application;
    }

    public final synchronized void invalidate() {
        this.myIsDirty = true;
        this.myResultReporter.setDirty();
        if (!this.myIsScheduled) {
            this.myIsScheduled = true;
            this.myApplication.executeOnPooledThread(this::revalidateUntilClean);
        }
    }

    private void revalidateUntilClean() {
        V result;
        do {
            this.markClean();
        } while (!this.submit(result = this.validate()));
    }

    private synchronized boolean submit(@NotNull V result) {
        this.myIsScheduled = this.myIsDirty;
        if (!this.myIsScheduled) {
            this.myResultReporter.report(result);
            return true;
        }
        return false;
    }

    private synchronized void markClean() {
        this.myIsDirty = false;
    }

    protected abstract void showValidationResult(V var1);

    @NotNull
    protected abstract V validate();

    private final class ResultReporter
    implements Runnable {
        private V myResult = null;
        private boolean myIsPending = false;

        private ResultReporter() {
        }

        public synchronized void report(@NotNull V value) {
            this.myResult = value;
            if (!this.myIsPending) {
                this.myIsPending = true;
                AsyncValidator.this.myApplication.invokeLater((Runnable)this, AsyncValidator.this.myApplication.getAnyModalityState());
            }
        }

        @Override
        public synchronized void run() {
            Object result = this.myResult;
            this.myResult = null;
            try {
                if (result != null) {
                    AsyncValidator.this.showValidationResult(result);
                }
            }
            finally {
                this.myIsPending = false;
            }
        }

        public synchronized void setDirty() {
            this.myResult = null;
        }
    }
}

