/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes;

import com.android.tools.idea.navigator.nodes.NonAndroidSourceType;
import com.android.tools.idea.navigator.nodes.NonAndroidSourceTypeNode;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.ProjectViewModuleNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.ui.Queryable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NonAndroidModuleNode
extends ProjectViewModuleNode {
    public NonAndroidModuleNode(Project project, Module value, ViewSettings viewSettings) {
        super(project, value, viewSettings);
    }

    @NotNull
    public Collection<AbstractTreeNode> getChildren() {
        Set<NonAndroidSourceType> sourceTypes = NonAndroidModuleNode.getNonEmptySourceTypes((Module)this.getValue());
        ArrayList nodes = Lists.newArrayListWithExpectedSize((int)sourceTypes.size());
        for (NonAndroidSourceType type : sourceTypes) {
            nodes.add(new NonAndroidSourceTypeNode(this.myProject, (Module)this.getValue(), this.getSettings(), type));
        }
        return nodes;
    }

    private static Set<NonAndroidSourceType> getNonEmptySourceTypes(Module module) {
        ContentEntry[] contentEntries;
        ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)module);
        HashSet sourceTypes = Sets.newHashSetWithExpectedSize((int)NonAndroidSourceType.values().length);
        for (ContentEntry entry : contentEntries = rootManager.getContentEntries()) {
            block1: for (NonAndroidSourceType type : NonAndroidSourceType.values()) {
                for (SourceFolder sourceFolder : entry.getSourceFolders(type.rootType)) {
                    if (sourceFolder.getFile() == null) continue;
                    sourceTypes.add(type);
                    continue block1;
                }
            }
        }
        return sourceTypes;
    }

    @Nullable
    public Comparable getSortKey() {
        return ((Module)this.getValue()).getName();
    }

    @Nullable
    public Comparable getTypeSortKey() {
        return this.getSortKey();
    }

    @Nullable
    public String toTestString(@Nullable Queryable.PrintInfo printInfo) {
        return String.format("%1$s (non-Android)", ((Module)this.getValue()).getName());
    }

    public boolean equals(Object o) {
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        return super.equals(o);
    }
}

