/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes;

import com.android.builder.model.NativeAndroidProject;
import com.android.builder.model.NativeArtifact;
import com.android.tools.idea.gradle.NativeAndroidGradleModel;
import com.android.tools.idea.gradle.facet.NativeAndroidGradleFacet;
import com.android.tools.idea.navigator.nodes.NativeAndroidLibraryNode;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.ProjectViewModuleNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NativeAndroidModuleNode
extends ProjectViewModuleNode {
    public NativeAndroidModuleNode(@NotNull Project project, @NotNull Module value, ViewSettings viewSettings) {
        super(project, value, viewSettings);
    }

    @NotNull
    public static Collection<AbstractTreeNode> getNativeSourceNodes(@NotNull Project project, @NotNull NativeAndroidGradleModel nativeAndroidModel, @NotNull ViewSettings viewSettings) {
        NativeAndroidProject nativeAndroidProject = nativeAndroidModel.getNativeAndroidProject();
        Set<String> sourceFileExtensions = nativeAndroidProject.getFileExtensions().keySet();
        NativeAndroidGradleModel.NativeVariant variant = nativeAndroidModel.getSelectedVariant();
        HashMultimap nativeLibraries = HashMultimap.create();
        for (NativeArtifact artifact : variant.getArtifacts()) {
            String artifactOutputFileName = artifact.getOutputFile().getName();
            nativeLibraries.put((Object)artifactOutputFileName, (Object)artifact);
        }
        if (nativeLibraries.keySet().size() == 1) {
            return NativeAndroidLibraryNode.getSourceDirectoryNodes(project, nativeLibraries.values(), viewSettings, sourceFileExtensions);
        }
        ArrayList children = Lists.newArrayList();
        for (String name : nativeLibraries.keySet()) {
            String nativeLibraryType = "";
            String nativeLibraryName = StringUtil.trimEnd((String)name, (String)".so");
            if (nativeLibraryName.length() < name.length()) {
                nativeLibraryType = "Shared Library";
            } else {
                nativeLibraryName = StringUtil.trimEnd((String)name, (String)".a");
                if (nativeLibraryName.length() < name.length()) {
                    nativeLibraryType = "Static Library";
                }
            }
            nativeLibraryName = StringUtil.trimStart((String)nativeLibraryName, (String)"lib");
            children.add(new NativeAndroidLibraryNode(project, nativeLibraryName, nativeLibraryType, nativeLibraries.get((Object)name), viewSettings, sourceFileExtensions));
        }
        return children;
    }

    @NotNull
    public Collection<AbstractTreeNode> getChildren() {
        Module module = (Module)this.getValue();
        if (module == null) {
            return ImmutableList.of();
        }
        NativeAndroidGradleFacet facet = NativeAndroidGradleFacet.getInstance(module);
        if (facet == null || facet.getNativeAndroidGradleModel() == null) {
            return ImmutableList.of();
        }
        return NativeAndroidModuleNode.getNativeSourceNodes(this.myProject, facet.getNativeAndroidGradleModel(), this.getSettings());
    }

    @Nullable
    public Comparable getSortKey() {
        Module module = (Module)this.getValue();
        if (module == null) {
            return null;
        }
        return module.getName();
    }

    @Nullable
    public Comparable getTypeSortKey() {
        return this.getSortKey();
    }

    @Nullable
    public String toTestString(@Nullable Queryable.PrintInfo printInfo) {
        Module module = (Module)this.getValue();
        if (module == null) {
            return null;
        }
        return String.format("%1$s (Native-Android-Gradle)", ((Module)this.getValue()).getName());
    }

    public boolean equals(Object o) {
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        return super.equals(o);
    }
}

