/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes;

import com.android.resources.ResourceFolderType;
import com.android.tools.idea.navigator.AndroidProjectTreeBuilder;
import com.android.tools.idea.navigator.AndroidProjectViewPane;
import com.android.tools.idea.navigator.nodes.AndroidResFolderTypeNode;
import com.android.tools.idea.navigator.nodes.AndroidSourceTypeNode;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidSourceType;
import org.jetbrains.annotations.NotNull;

public class AndroidResFolderNode
extends AndroidSourceTypeNode {
    public AndroidResFolderNode(@NotNull Project project, @NotNull AndroidFacet facet, @NotNull ViewSettings viewSettings, @NotNull Set<VirtualFile> sourceRoots, @NotNull AndroidProjectViewPane projectViewPane) {
        super(project, facet, viewSettings, AndroidSourceType.RES, sourceRoots, projectViewPane);
    }

    @Override
    @NotNull
    public Collection<? extends AbstractTreeNode> getChildren() {
        ArrayList resFolders = Lists.newArrayList();
        for (PsiDirectory psiDirectory : this.getSourceDirectories()) {
            resFolders.addAll(Lists.newArrayList((Object[])psiDirectory.getSubdirectories()));
        }
        HashMultimap foldersByResourceType = HashMultimap.create();
        for (PsiDirectory resFolder : resFolders) {
            ResourceFolderType type = ResourceFolderType.getFolderType((String)resFolder.getName());
            if (type == null) continue;
            foldersByResourceType.put((Object)type, (Object)resFolder);
        }
        AndroidProjectTreeBuilder androidProjectTreeBuilder = (AndroidProjectTreeBuilder)this.myProjectViewPane.getTreeBuilder();
        ArrayList children = Lists.newArrayListWithExpectedSize((int)foldersByResourceType.size());
        for (ResourceFolderType type : foldersByResourceType.keySet()) {
            Set folders = foldersByResourceType.get((Object)type);
            AndroidResFolderTypeNode androidResFolderTypeNode = new AndroidResFolderTypeNode(this.myProject, (AndroidFacet)((Object)this.getValue()), Lists.newArrayList((Iterable)folders), this.getSettings(), type, this.myProjectViewPane);
            children.add(androidResFolderTypeNode);
            for (PsiDirectory folder : folders) {
                androidProjectTreeBuilder.createMapping(folder.getVirtualFile(), (AbstractTreeNode)androidResFolderTypeNode);
            }
        }
        return children;
    }
}

