/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes;

import com.android.tools.idea.navigator.AndroidProjectViewPane;
import com.android.tools.idea.navigator.nodes.DirectoryGroupNode;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.ui.SimpleTextAttributes;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.IdeaSourceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidManifestFileNode
extends PsiFileNode
implements DirectoryGroupNode {
    @NotNull
    private final AndroidFacet myFacet;

    public AndroidManifestFileNode(@NotNull Project project, @NotNull PsiFile psiFile, @NotNull ViewSettings settings, @NotNull AndroidFacet facet) {
        super(project, psiFile, settings);
        this.myFacet = facet;
    }

    public void update(PresentationData data) {
        super.update(data);
        PsiFile file = (PsiFile)this.getValue();
        if (file == null) {
            return;
        }
        IdeaSourceProvider sourceProvider = AndroidManifestFileNode.getSourceProvider(this.myFacet, file);
        if (sourceProvider != null && !"main".equals(sourceProvider.getName())) {
            data.addText(file.getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            data.addText(" (" + sourceProvider.getName() + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
            data.setPresentableText(file.getName());
        }
    }

    @Nullable
    public static IdeaSourceProvider getSourceProvider(@NotNull AndroidFacet facet, @NotNull PsiFile file) {
        for (IdeaSourceProvider provider : AndroidProjectViewPane.getSourceProviders(facet)) {
            if (!file.getVirtualFile().equals(provider.getManifestFile())) continue;
            return provider;
        }
        return null;
    }

    @Nullable
    public Comparable getSortKey() {
        PsiFile file = (PsiFile)this.getValue();
        if (file == null) {
            return "";
        }
        IdeaSourceProvider sourceProvider = AndroidManifestFileNode.getSourceProvider(this.myFacet, file);
        if (sourceProvider == null || "main".equals(sourceProvider.getName())) {
            return "";
        }
        return sourceProvider.getName();
    }

    public Comparable getTypeSortKey() {
        return this.getSortKey();
    }

    @Override
    @NotNull
    public PsiDirectory[] getDirectories() {
        return PsiDirectory.EMPTY_ARRAY;
    }

    @Nullable
    public String toTestString(@Nullable Queryable.PrintInfo printInfo) {
        PsiFile file = (PsiFile)this.getValue();
        if (file == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(file.getName());
        sb.append(" (");
        sb.append(AndroidManifestFileNode.getSourceProvider(this.myFacet, (PsiFile)this.getValue()).getName());
        sb.append(")");
        return sb.toString();
    }
}

