/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.monitor.ui.network.view;

import com.android.tools.adtui.Animatable;
import com.android.tools.adtui.LegendComponent;
import com.android.tools.adtui.Range;
import com.android.tools.adtui.chart.StateChart;
import com.android.tools.adtui.model.LegendRenderData;
import com.android.tools.adtui.model.RangedSeries;
import com.android.tools.idea.monitor.ui.BaseSegment;
import com.android.tools.idea.monitor.ui.ProfilerEventListener;
import com.intellij.ui.JBColor;
import com.intellij.util.EventDispatcher;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class RadioSegment
extends BaseSegment {
    private static final String SEGMENT_NAME = "Radio";
    private LegendComponent mLegendComponent;
    private StateChart<RadioState> mStateChart;

    public RadioSegment(@NotNull Range sharedRange, @NotNull EventDispatcher<ProfilerEventListener> dispatcher) {
        super(SEGMENT_NAME, sharedRange, dispatcher);
    }

    private static EnumMap<RadioState, Color> getRadioStateColor() {
        EnumMap<RadioState, Color> colors = new EnumMap<RadioState, Color>(RadioState.class);
        colors.put(RadioState.FULL, JBColor.BLUE.darker());
        colors.put(RadioState.LOW, (Color)JBColor.BLUE);
        colors.put(RadioState.IDLE, JBColor.BLUE.brighter());
        return colors;
    }

    private static EnumMap<RadioState, String> getRadioStateLabel() {
        EnumMap<RadioState, String> labels = new EnumMap<RadioState, String>(RadioState.class);
        labels.put(RadioState.FULL, "Radio Full");
        labels.put(RadioState.LOW, "Radio Low");
        labels.put(RadioState.IDLE, "Radio Idle");
        return labels;
    }

    @Override
    public void createComponentsList(@NotNull List<Animatable> animatables) {
        EnumMap<RadioState, Color> colorsMap = RadioSegment.getRadioStateColor();
        EnumMap<RadioState, String> labelsMap = RadioSegment.getRadioStateLabel();
        this.mStateChart = new StateChart(colorsMap);
        ArrayList<LegendRenderData> legendRenderDataList = new ArrayList<LegendRenderData>();
        for (RadioState state : RadioState.values()) {
            int ordinal = state.ordinal();
            LegendRenderData renderData = new LegendRenderData(LegendRenderData.IconType.LINE, colorsMap.get((Object)state), labelsMap.get((Object)state));
            legendRenderDataList.add(renderData);
        }
        this.mLegendComponent = new LegendComponent(LegendComponent.Orientation.HORIZONTAL, 100);
        this.mLegendComponent.setLegendData(legendRenderDataList);
        animatables.add((Animatable)this.mStateChart);
        animatables.add((Animatable)this.mLegendComponent);
    }

    @Override
    protected void setTopCenterContent(@NotNull JPanel panel) {
        panel.add((Component)this.mLegendComponent, "East");
    }

    @Override
    protected void setCenterContent(@NotNull JPanel panel) {
        panel.add((Component)this.mStateChart, "Center");
    }

    public void addRadioStateSeries(RangedSeries<RadioState> series) {
        this.mStateChart.addSeries(series);
    }

    public static enum RadioState {
        FULL,
        LOW,
        IDLE;

    }
}

