/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.monitor.ui.network.view;

import com.android.tools.adtui.Range;
import com.android.tools.adtui.chart.linechart.LineConfig;
import com.android.tools.adtui.common.formatter.BaseAxisFormatter;
import com.android.tools.adtui.common.formatter.MemoryAxisFormatter;
import com.android.tools.adtui.common.formatter.SingleUnitAxisFormatter;
import com.android.tools.idea.monitor.datastore.SeriesDataStore;
import com.android.tools.idea.monitor.datastore.SeriesDataType;
import com.android.tools.idea.monitor.ui.BaseLineChartSegment;
import com.android.tools.idea.monitor.ui.BaseSegment;
import com.android.tools.idea.monitor.ui.ProfilerEventListener;
import com.android.tools.idea.monitor.ui.network.view.Constants;
import com.intellij.util.EventDispatcher;
import org.jetbrains.annotations.NotNull;

public class NetworkSegment
extends BaseLineChartSegment {
    private static final String SEGMENT_NAME = "Network";
    private static final String SENDING = "Sending";
    private static final String RECEIVING = "Receiving";
    private static final String CONNECTIONS = "Connections";
    private static final BaseAxisFormatter BANDWIDTH_AXIS_FORMATTER = MemoryAxisFormatter.DEFAULT;
    private static final BaseAxisFormatter CONNECTIONS_AXIS_FORMATTER = new SingleUnitAxisFormatter(1, 10, 1, "");

    public NetworkSegment(@NotNull Range timeRange, @NotNull SeriesDataStore dataStore, @NotNull EventDispatcher<ProfilerEventListener> dispatcher) {
        super(SEGMENT_NAME, timeRange, dataStore, BANDWIDTH_AXIS_FORMATTER, CONNECTIONS_AXIS_FORMATTER, dispatcher);
    }

    @Override
    public BaseSegment.SegmentType getSegmentType() {
        return BaseSegment.SegmentType.NETWORK;
    }

    @Override
    protected void updateChartLines(boolean isExpanded) {
        this.addLine(SeriesDataType.NETWORK_SENDING, SENDING, new LineConfig(Constants.NETWORK_SENDING_COLOR), this.mLeftAxisRange);
        this.addLine(SeriesDataType.NETWORK_RECEIVING, RECEIVING, new LineConfig(Constants.NETWORK_RECEIVING_COLOR), this.mLeftAxisRange);
        if (isExpanded) {
            this.addLine(SeriesDataType.NETWORK_CONNECTIONS, CONNECTIONS, new LineConfig(Constants.NETWORK_CONNECTIONS_COLOR).setStepped(true), this.mRightAxisRange);
        }
    }
}

