/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.monitor.ui.network.view;

import com.android.tools.adtui.Animatable;
import com.android.tools.adtui.Range;
import com.android.tools.adtui.chart.StateChart;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.model.RangedSeries;
import com.android.tools.idea.monitor.ui.BaseSegment;
import com.android.tools.idea.monitor.ui.ProfilerEventListener;
import com.android.tools.idea.monitor.ui.network.view.Constants;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.JBTable;
import com.intellij.util.EventDispatcher;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;

public class NetworkCaptureSegment
extends BaseSegment {
    private static final String SEGMENT_NAME = "Network Capture";
    private static final int ROW_HEIGHT_PADDING = 5;
    private static final EnumMap<NetworkState, Color> NETWORK_STATE_COLORS = new EnumMap(NetworkState.class);
    private int mRowHeight;
    @NotNull
    private final List<StateChart<NetworkState>> mCharts = new ArrayList<StateChart<NetworkState>>();
    @NotNull
    private final List<RangedSeries<NetworkState>> mData;

    public NetworkCaptureSegment(@NotNull Range timeRange, @NotNull List<RangedSeries<NetworkState>> data, @NotNull EventDispatcher<ProfilerEventListener> dispatcher) {
        super(SEGMENT_NAME, timeRange, dispatcher);
        this.mData = data;
        int defaultFontHeight = this.getFontMetrics((Font)AdtUiUtils.DEFAULT_FONT).getHeight();
        this.mRowHeight = defaultFontHeight + 5;
    }

    @Override
    public void createComponentsList(@NotNull List<Animatable> animatables) {
        for (RangedSeries<NetworkState> series : this.mData) {
            StateChart chart = new StateChart(NETWORK_STATE_COLORS);
            chart.addSeries(series);
            animatables.add((Animatable)chart);
            this.mCharts.add((StateChart<NetworkState>)chart);
        }
    }

    @NotNull
    private JTable createInformationTable() {
        JBTable table = new JBTable((TableModel)new AbstractTableModel(){
            final String[] SAMPLE = new String[]{"2", "http://myapp.example.com/list/xml", "746 K", "322 ms", ""};

            @Override
            public int getRowCount() {
                return NetworkCaptureSegment.this.mCharts.size();
            }

            @Override
            public int getColumnCount() {
                return this.SAMPLE.length;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                if (columnIndex == 0) {
                    return String.valueOf(rowIndex);
                }
                return this.SAMPLE[columnIndex];
            }
        });
        table.setFont((Font)AdtUiUtils.DEFAULT_FONT);
        table.setOpaque(false);
        ((DefaultTableCellRenderer)table.getDefaultRenderer(Object.class)).setOpaque(false);
        table.setRowHeight(this.mRowHeight);
        return table;
    }

    @NotNull
    private JTable createStateChartTable() {
        JBTable table = new JBTable((TableModel)new AbstractTableModel(){

            @Override
            public int getRowCount() {
                return NetworkCaptureSegment.this.mCharts.size();
            }

            @Override
            public int getColumnCount() {
                return 1;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                return NetworkCaptureSegment.this.mCharts.get(rowIndex);
            }
        });
        table.setDefaultRenderer(Object.class, (t, value, isSelected, hasFocus, row, column) -> this.mCharts.get(row));
        table.setRowHeight(this.mRowHeight);
        return table;
    }

    @Override
    protected void setCenterContent(@NotNull JPanel panel) {
        JLayeredPane pane = new JLayeredPane();
        pane.add(this.createInformationTable());
        pane.add(this.createStateChartTable());
        pane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                JLayeredPane host = (JLayeredPane)e.getComponent();
                if (host != null) {
                    Dimension dim = host.getSize();
                    for (Component c : host.getComponents()) {
                        c.setBounds(0, 0, dim.width, dim.height);
                    }
                }
            }
        });
        pane.setPreferredSize(new Dimension(0, this.mRowHeight * this.mCharts.size()));
        panel.add((Component)new JBScrollPane((Component)pane), "Center");
    }

    static {
        NETWORK_STATE_COLORS.put(NetworkState.SENDING, Constants.NETWORK_SENDING_COLOR);
        NETWORK_STATE_COLORS.put(NetworkState.RECEIVING, Constants.NETWORK_RECEIVING_COLOR);
        NETWORK_STATE_COLORS.put(NetworkState.WAITING, Constants.NETWORK_WAITING_COLOR);
        NETWORK_STATE_COLORS.put(NetworkState.NONE, (Color)JBColor.WHITE);
    }

    public static enum NetworkState {
        SENDING,
        RECEIVING,
        WAITING,
        NONE;

    }
}

