/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.monitor.ui.cpu.view;

import com.android.tools.adtui.Animatable;
import com.android.tools.adtui.AnimatedComponent;
import com.android.tools.adtui.Range;
import com.android.tools.adtui.chart.StateChart;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.DefaultDataSeries;
import com.android.tools.adtui.model.RangedSeries;
import com.android.tools.idea.monitor.datastore.SeriesDataStore;
import com.android.tools.idea.monitor.ui.BaseSegment;
import com.android.tools.idea.monitor.ui.ProfilerEventListener;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLayeredPane;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.AbstractBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThreadsSegment
extends BaseSegment
implements Animatable {
    private static final String SEGMENT_NAME = "Threads";
    private static final int THREADS_CHART_VERTICAL_PADDING = JBUI.scale((int)2);
    private static final int LIST_ITEM_SELECTION_BORDER_THICKNESS = JBUI.scale((int)2);
    private static final int THREADS_NAME_LEFT_MARGIN = JBUI.scale((int)10);
    private static final Color THREADS_NAME_TEXT_COLOR = new JBColor(Color.BLACK, Color.BLACK);
    private static final LineBorder LIST_ITEM_SELECTED_BORDER = new LineBorder((Color)JBColor.BLUE, LIST_ITEM_SELECTION_BORDER_THICKNESS);
    private static final EmptyBorder LIST_ITEM_UNSELECTED_BORDER = new EmptyBorder(0, 0, 0, 0);
    private final int mFontHeight = JBUI.scale((int)this.getFontMetrics((Font)AdtUiUtils.DEFAULT_FONT).getHeight());
    private final int mThreadsChartHeight = this.mFontHeight + THREADS_CHART_VERTICAL_PADDING * 2;
    private final int mCellHeight = 2 * this.mFontHeight;
    private final int mThreadsChartY = (this.mCellHeight - this.mThreadsChartHeight) / 2;
    private final Map<Thread, StateChart<Thread.State>> mThreadsStateCharts = new HashMap<Thread, StateChart<Thread.State>>();
    private final DefaultListModel<Thread> mThreadsListModel = new DefaultListModel();
    private final JBList mThreadsList = new JBList(this.mThreadsListModel);
    @NotNull
    private final Range mTimeRange;
    private static EnumMap<Thread.State, Color> mThreadStateColor;
    @Nullable
    private final ThreadSelectedListener mThreadSelectedListener;
    @NotNull
    private SeriesDataStore mSeriesDataStore;
    @NotNull
    private final Map<Thread, DefaultDataSeries<Thread.State>> mThreadsStateSeries;

    public ThreadsSegment(@NotNull Range timeRange, @NotNull SeriesDataStore dataStore, @NotNull EventDispatcher<ProfilerEventListener> dispatcher, @Nullable ThreadSelectedListener threadSelectedListener) {
        super(SEGMENT_NAME, timeRange, dispatcher);
        this.mTimeRange = timeRange;
        this.mSeriesDataStore = dataStore;
        this.mThreadsStateSeries = new HashMap<Thread, DefaultDataSeries<Thread.State>>();
        this.mThreadSelectedListener = threadSelectedListener;
        this.initialize();
    }

    @Override
    protected boolean hasLeftContent() {
        return false;
    }

    @Override
    protected boolean hasRightContent() {
        return false;
    }

    @NotNull
    private static EnumMap<Thread.State, Color> getThreadStateColor() {
        if (mThreadStateColor != null) {
            return mThreadStateColor;
        }
        mThreadStateColor = new EnumMap(Thread.State.class);
        mThreadStateColor.put(Thread.State.RUNNABLE, (Color)new JBColor(7127419, 7127419));
        mThreadStateColor.put(Thread.State.TIMED_WAITING, (Color)new JBColor(0xAAAAAA, 0xAAAAAA));
        mThreadStateColor.put(Thread.State.WAITING, (Color)new JBColor(0xAAAAAA, 0xAAAAAA));
        mThreadStateColor.put(Thread.State.BLOCKED, (Color)new JBColor(0x5A5A5A, 0x5A5A5A));
        mThreadStateColor.put(Thread.State.TERMINATED, AdtUiUtils.DEFAULT_BACKGROUND_COLOR);
        return mThreadStateColor;
    }

    private void initialize() {
        this.mThreadsList.setCellRenderer((ListCellRenderer)new ThreadsStateCellRenderer());
        this.mThreadsList.setSelectionBackground(AdtUiUtils.DEFAULT_BACKGROUND_COLOR);
        this.mThreadsList.setFixedCellHeight(this.mCellHeight);
        if (this.mThreadSelectedListener != null) {
            this.mThreadsList.addListSelectionListener(event -> {
                int[] selectedThreadsIndices = this.mThreadsList.getSelectedIndices();
                ArrayList<Thread> selectedThreads = new ArrayList<Thread>();
                for (int i = 0; i < selectedThreadsIndices.length; ++i) {
                    selectedThreads.add(this.mThreadsListModel.get(i));
                }
                this.mThreadSelectedListener.onSelected(selectedThreads);
            });
        }
    }

    @Override
    protected void setCenterContent(@NotNull JPanel panel) {
        JBLayeredPane centerPane = new JBLayeredPane();
        JBScrollPane scrollPane = new JBScrollPane((Component)this.mThreadsList);
        centerPane.add((Component)scrollPane);
        centerPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                JLayeredPane host = (JLayeredPane)e.getComponent();
                if (host != null) {
                    Dimension dim = host.getSize();
                    for (Component c : host.getComponents()) {
                        c.setBounds(0, 0, dim.width, dim.height);
                    }
                }
            }
        });
        panel.add((Component)centerPane, "Center");
    }

    public void addThreadStateSeries(Thread thread) {
        if (this.mThreadsStateSeries.containsKey(thread)) {
            return;
        }
        this.createThreadStateChart(thread);
    }

    public Map<Thread, DefaultDataSeries<Thread.State>> getThreadsStateSeries() {
        return this.mThreadsStateSeries;
    }

    private void createThreadStateChart(Thread thread) {
        StateChart stateChart = new StateChart(ThreadsSegment.getThreadStateColor());
        this.mThreadsStateCharts.put(thread, (StateChart<Thread.State>)stateChart);
        DefaultDataSeries defaultData = new DefaultDataSeries();
        RangedSeries threadSeries = new RangedSeries(this.mTimeRange, (DataSeries)defaultData);
        this.mThreadsStateSeries.put(thread, (DefaultDataSeries<Thread.State>)defaultData);
        this.mThreadsStateCharts.get(thread).addSeries(threadSeries);
        this.mThreadsListModel.addElement(thread);
    }

    public void reset() {
        this.mThreadsStateCharts.values().forEach(AnimatedComponent::reset);
    }

    public void animate(float frameLength) {
        this.mThreadsStateCharts.values().forEach(chart -> chart.animate(frameLength));
    }

    public void postAnimate() {
        this.mThreadsStateCharts.values().forEach(Animatable::postAnimate);
    }

    private class ThreadsStateCellRenderer
    implements ListCellRenderer<Thread> {
        private ThreadsStateCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends Thread> list, Thread thread, int index, boolean isSelected, boolean cellHasFocus) {
            JLayeredPane cellPane = new JLayeredPane();
            cellPane.setBounds(0, 0, list.getWidth(), ThreadsSegment.this.mCellHeight);
            AbstractBorder cellBorder = isSelected ? LIST_ITEM_SELECTED_BORDER : LIST_ITEM_UNSELECTED_BORDER;
            cellPane.setBorder(cellBorder);
            JLabel threadName = new JLabel(thread.getName());
            threadName.setFont((Font)AdtUiUtils.DEFAULT_FONT);
            threadName.setForeground(THREADS_NAME_TEXT_COLOR);
            threadName.setBounds(THREADS_NAME_LEFT_MARGIN, 0, list.getWidth(), ThreadsSegment.this.mCellHeight);
            StateChart threadStateChart = (StateChart)ThreadsSegment.this.mThreadsStateCharts.get(thread);
            threadStateChart.setBounds(BaseSegment.getSpacerWidth(), ThreadsSegment.this.mThreadsChartY, list.getWidth() - BaseSegment.getSpacerWidth(), ThreadsSegment.this.mThreadsChartHeight);
            cellPane.add(threadName);
            cellPane.add((Component)threadStateChart);
            return cellPane;
        }
    }

    public static interface ThreadSelectedListener {
        public void onSelected(@NotNull List<Thread> var1);
    }
}

