/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.monitor.tool;

import com.android.ddmlib.Client;
import com.android.ddmlib.IDevice;
import com.android.tools.adtui.AccordionLayout;
import com.android.tools.adtui.Animatable;
import com.android.tools.adtui.AnimatedTimeRange;
import com.android.tools.adtui.AxisComponent;
import com.android.tools.adtui.Choreographer;
import com.android.tools.adtui.Range;
import com.android.tools.adtui.RangeScrollbar;
import com.android.tools.adtui.SelectionComponent;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.common.formatter.BaseAxisFormatter;
import com.android.tools.adtui.common.formatter.TimeAxisFormatter;
import com.android.tools.idea.ddms.DeviceContext;
import com.android.tools.idea.ddms.DevicePanel;
import com.android.tools.idea.monitor.datastore.SeriesDataStore;
import com.android.tools.idea.monitor.datastore.SeriesDataStoreImpl;
import com.android.tools.idea.monitor.profilerclient.DeviceProfilerService;
import com.android.tools.idea.monitor.profilerclient.ProfilerService;
import com.android.tools.idea.monitor.ui.BaseSegment;
import com.android.tools.idea.monitor.ui.ProfilerEventListener;
import com.android.tools.idea.monitor.ui.TimeAxisSegment;
import com.android.tools.idea.monitor.ui.cpu.view.CpuUsageSegment;
import com.android.tools.idea.monitor.ui.cpu.view.ThreadsSegment;
import com.android.tools.idea.monitor.ui.memory.view.MemorySegment;
import com.android.tools.idea.monitor.ui.network.view.NetworkSegment;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.panels.HorizontalLayout;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidMonitorToolWindow
implements Disposable {
    private static final int CHOREOGRAPHER_FPS = 60;
    private static final int TOOLBAR_HORIZONTAL_GAP = JBUI.scale((int)5);
    private static final int MONITOR_MAX_HEIGHT = JBUI.scale((int)Short.MAX_VALUE);
    private static final int MONITOR_PREFERRED_HEIGHT = JBUI.scale((int)200);
    private static final int TIME_AXIS_HEIGHT = JBUI.scale((int)20);
    @NotNull
    private final Project myProject;
    @NotNull
    private DeviceContext myDeviceContext;
    @Nullable
    private IDevice mySelectedDevice;
    @Nullable
    private Client mySelectedClient;
    @Nullable
    private DeviceProfilerService mySelectedDeviceProfilerService;
    @NotNull
    private final JPanel myComponent;
    @NotNull
    private final Choreographer myChoreographer;
    @NotNull
    private SeriesDataStore myDataStore;
    private SelectionComponent mySelection;
    private Range myXRange;
    private AxisComponent myTimeAxis;
    private RangeScrollbar myScrollbar;
    private JPanel mySegmentsContainer;
    private EventDispatcher<ProfilerEventListener> myEventDispatcher;
    private AccordionLayout mySegmentsLayout;
    private JButton myCollapseSegmentsButton;
    private BaseSegment myThreadsSegment;

    public AndroidMonitorToolWindow(@NotNull Project project) {
        this.myProject = project;
        this.myComponent = new JPanel(new BorderLayout());
        this.myDataStore = new SeriesDataStoreImpl();
        this.myChoreographer = new Choreographer(60, (JComponent)this.myComponent);
        this.myChoreographer.register(this.createComponentsList());
        this.myEventDispatcher = EventDispatcher.create(ProfilerEventListener.class);
        this.myDeviceContext = new DeviceContext();
        this.setupDevice();
        this.populateUi();
    }

    public void dispose() {
    }

    private List<Animatable> createComponentsList() {
        Range xGlobalRange = new Range();
        AnimatedTimeRange animatedTimeRange = new AnimatedTimeRange(xGlobalRange, System.currentTimeMillis());
        Range xSelectionRange = new Range();
        this.myXRange = new Range();
        this.myScrollbar = new RangeScrollbar(xGlobalRange, this.myXRange);
        this.myTimeAxis = new AxisComponent(this.myXRange, xGlobalRange, "TIME", AxisComponent.AxisOrientation.BOTTOM, 0, 0, false, (BaseAxisFormatter)TimeAxisFormatter.DEFAULT);
        this.mySegmentsContainer = new JBPanel();
        this.mySegmentsLayout = new AccordionLayout((Container)this.mySegmentsContainer, AccordionLayout.Orientation.VERTICAL);
        this.mySegmentsContainer.setLayout((LayoutManager)this.mySegmentsLayout);
        this.mySelection = new SelectionComponent((Component)this.mySegmentsContainer, this.myTimeAxis, xSelectionRange, xGlobalRange, this.myXRange);
        return Arrays.asList(this.mySegmentsLayout, animatedTimeRange, this.mySelection, this.myScrollbar, this.myTimeAxis, this.myXRange, xGlobalRange, xSelectionRange);
    }

    private void setupDevice() {
        this.mySelectedDevice = this.myDeviceContext.getSelectedDevice();
        if (this.mySelectedDevice != null) {
            this.connectToDevice();
        }
        this.myDeviceContext.addListener(new DeviceContext.DeviceSelectionListener(){

            @Override
            public void deviceSelected(@Nullable IDevice device) {
                if (device == AndroidMonitorToolWindow.this.mySelectedDevice) {
                    return;
                }
                AndroidMonitorToolWindow.this.disconnectFromDevice();
                AndroidMonitorToolWindow.this.mySelectedDevice = device;
                AndroidMonitorToolWindow.this.connectToDevice();
            }

            @Override
            public void deviceChanged(@NotNull IDevice device, int changeMask) {
                if ((changeMask & 1) > 0) {
                    if (device.isOnline() && AndroidMonitorToolWindow.this.mySelectedDeviceProfilerService == null) {
                        AndroidMonitorToolWindow.this.connectToDevice();
                    } else if (device.isOffline() || device.getState() == IDevice.DeviceState.DISCONNECTED) {
                        AndroidMonitorToolWindow.this.disconnectFromDevice();
                    }
                }
            }

            @Override
            public void clientSelected(@Nullable Client c) {
                AndroidMonitorToolWindow.this.mySelectedClient = c;
            }
        }, this);
    }

    private void createToolbarComponent() {
        JBPanel toolbar = new JBPanel((LayoutManager)new HorizontalLayout(TOOLBAR_HORIZONTAL_GAP));
        DevicePanel devicePanel = new DevicePanel(this.myProject, this.myDeviceContext);
        this.myCollapseSegmentsButton = new JButton();
        this.myCollapseSegmentsButton.setIcon(AllIcons.Actions.Back);
        this.myCollapseSegmentsButton.addActionListener(event -> ((ProfilerEventListener)this.myEventDispatcher.getMulticaster()).profilersReset());
        this.myCollapseSegmentsButton.setVisible(false);
        toolbar.add("RIGHT", (Component)devicePanel.getComponent());
        toolbar.add("LEFT", (Component)this.myCollapseSegmentsButton);
        this.myComponent.add((Component)toolbar, "North");
    }

    private void populateUi() {
        this.createToolbarComponent();
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        JBPanel gridBagPanel = new JBPanel();
        gridBagPanel.setBorder(BorderFactory.createLineBorder(AdtUiUtils.DEFAULT_BORDER_COLOR, 1));
        gridBagPanel.setLayout((LayoutManager)gbl);
        gbc.fill = 1;
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gridBagPanel.add((Component)this.mySelection, (Object)gbc);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 4;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gridBagPanel.add((Component)this.mySegmentsContainer, (Object)gbc);
        gbc.gridy = 1;
        gridBagPanel.add((Component)this.myScrollbar, (Object)gbc);
        final BaseSegment networkSegment = this.createMonitorSegment(BaseSegment.SegmentType.NETWORK);
        final BaseSegment memorySegment = this.createMonitorSegment(BaseSegment.SegmentType.MEMORY);
        final BaseSegment cpuSegment = this.createMonitorSegment(BaseSegment.SegmentType.CPU);
        BaseSegment timeSegment = this.createSegment(BaseSegment.SegmentType.TIME, TIME_AXIS_HEIGHT, TIME_AXIS_HEIGHT, TIME_AXIS_HEIGHT);
        this.mySegmentsContainer.add(networkSegment);
        this.mySegmentsContainer.add(memorySegment);
        this.mySegmentsContainer.add(cpuSegment);
        this.mySegmentsContainer.add(timeSegment);
        Dimension leftSpacer = new Dimension(BaseSegment.getSpacerWidth() + networkSegment.getLabelColumnWidth(), 0);
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.gridwidth = 2;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gridBagPanel.add((Component)new Box.Filler(leftSpacer, leftSpacer, leftSpacer), (Object)gbc);
        Dimension rightSpacer = new Dimension(BaseSegment.getSpacerWidth(), 0);
        gbc.gridy = 0;
        gbc.gridx = 3;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        final Box.Filler rightSpacerFiller = new Box.Filler(rightSpacer, rightSpacer, rightSpacer);
        gridBagPanel.add((Component)rightSpacerFiller, (Object)gbc);
        this.myComponent.add((Component)gridBagPanel);
        this.myEventDispatcher.addListener((EventListener)new ProfilerEventListener(){

            @Override
            public void profilerExpanded(@NotNull BaseSegment.SegmentType segmentType) {
                switch (segmentType) {
                    case NETWORK: {
                        AndroidMonitorToolWindow.this.mySegmentsLayout.setState((Component)networkSegment, AccordionLayout.AccordionState.MAXIMIZE);
                        break;
                    }
                    case CPU: {
                        AndroidMonitorToolWindow.this.mySegmentsLayout.setState((Component)cpuSegment, AccordionLayout.AccordionState.MAXIMIZE);
                        if (AndroidMonitorToolWindow.this.myThreadsSegment != null) break;
                        AndroidMonitorToolWindow.this.myThreadsSegment = AndroidMonitorToolWindow.this.createMonitorSegment(BaseSegment.SegmentType.THREADS);
                        AndroidMonitorToolWindow.this.mySegmentsContainer.add(AndroidMonitorToolWindow.this.myThreadsSegment);
                        AndroidMonitorToolWindow.this.mySegmentsLayout.setState((Component)AndroidMonitorToolWindow.this.myThreadsSegment, AccordionLayout.AccordionState.MAXIMIZE);
                        break;
                    }
                    case MEMORY: {
                        AndroidMonitorToolWindow.this.mySegmentsLayout.setState((Component)memorySegment, AccordionLayout.AccordionState.MAXIMIZE);
                        break;
                    }
                }
                rightSpacerFiller.setVisible(true);
                AndroidMonitorToolWindow.this.myCollapseSegmentsButton.setVisible(true);
            }

            @Override
            public void profilersReset() {
                AndroidMonitorToolWindow.this.mySegmentsLayout.resetComponents();
                AndroidMonitorToolWindow.this.destroyDetailedComponents();
                rightSpacerFiller.setVisible(false);
                AndroidMonitorToolWindow.this.myCollapseSegmentsButton.setVisible(false);
            }
        });
    }

    public JComponent getComponent() {
        return this.myComponent;
    }

    private BaseSegment createSegment(BaseSegment.SegmentType type, int minHeight, int preferredHeight, int maxHeight) {
        BaseSegment segment;
        switch (type) {
            case TIME: {
                segment = new TimeAxisSegment(this.myXRange, this.myTimeAxis, this.myEventDispatcher);
                break;
            }
            case CPU: {
                segment = new CpuUsageSegment(this.myXRange, this.myDataStore, this.myEventDispatcher);
                break;
            }
            case THREADS: {
                segment = new ThreadsSegment(this.myXRange, this.myDataStore, this.myEventDispatcher, null);
                break;
            }
            case MEMORY: {
                segment = new MemorySegment(this.myXRange, this.myDataStore, this.myEventDispatcher);
                break;
            }
            default: {
                segment = new NetworkSegment(this.myXRange, this.myDataStore, this.myEventDispatcher);
            }
        }
        segment.setMinimumSize(new Dimension(0, minHeight));
        segment.setPreferredSize(new Dimension(0, preferredHeight));
        segment.setMaximumSize(new Dimension(0, maxHeight));
        segment.setBorder(BorderFactory.createLineBorder((Color)JBColor.GRAY));
        ArrayList<Animatable> segmentAnimatables = new ArrayList<Animatable>();
        segment.createComponentsList(segmentAnimatables);
        this.myChoreographer.register(segmentAnimatables);
        segment.initializeComponents();
        return segment;
    }

    private BaseSegment createMonitorSegment(BaseSegment.SegmentType type) {
        return this.createSegment(type, 0, MONITOR_PREFERRED_HEIGHT, MONITOR_MAX_HEIGHT);
    }

    private void destroyDetailedComponents() {
        if (this.myThreadsSegment != null) {
            this.mySegmentsContainer.remove(this.myThreadsSegment);
            this.myThreadsSegment = null;
        }
    }

    private void disconnectFromDevice() {
        if (this.mySelectedDeviceProfilerService != null) {
            ProfilerService.getInstance().disconnect(this, this.mySelectedDeviceProfilerService);
            this.mySelectedDeviceProfilerService = null;
        }
    }

    private void connectToDevice() {
        if (this.mySelectedDevice == null) {
            return;
        }
        if (this.mySelectedDevice.isOffline()) {
            return;
        }
        assert (this.mySelectedDevice.isOnline());
        this.mySelectedDeviceProfilerService = ProfilerService.getInstance().connect(this, this.mySelectedDevice);
    }
}

