/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.monitor.profilerclient;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.monitor.profilerclient.DevicePortForwarder;
import com.android.tools.idea.monitor.profilerclient.ProfilerService;
import com.android.tools.profiler.proto.DeviceServiceGrpc;
import com.android.tools.profiler.proto.MemoryServiceGrpc;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeviceProfilerService {
    private static final String DEVICE_UNIX_DOMAIN_NAME = "StudioProfiler";
    private static final int DEVICE_PORT = 12389;
    private static final Logger LOG = Logger.getInstance((String)DeviceProfilerService.class.getCanonicalName());
    @NotNull
    private final Set<Object> myUserKeys = new HashSet<Object>();
    @NotNull
    private final IDevice myDevice;
    @NotNull
    private final ManagedChannel myChannel;
    @NotNull
    private final DeviceServiceGrpc.DeviceServiceBlockingStub myDeviceService;
    @NotNull
    private final MemoryServiceGrpc.MemoryServiceBlockingStub myMemoryService;
    private final int myPort;

    private DeviceProfilerService(@NotNull IDevice device, int port) {
        this.myDevice = device;
        this.myPort = port;
        this.myChannel = ManagedChannelBuilder.forAddress((String)"localhost", (int)this.myPort).usePlaintext(true).build();
        this.myDeviceService = DeviceServiceGrpc.newBlockingStub((Channel)this.myChannel);
        this.myMemoryService = MemoryServiceGrpc.newBlockingStub((Channel)this.myChannel);
        Disposer.register((Disposable)ApplicationManager.getApplication(), () -> {
            if (!this.myUserKeys.isEmpty()) {
                for (Object userKey : this.myUserKeys) {
                    LOG.warn("DeviceProfilerService has not been fully unregistered from " + userKey);
                }
            }
        });
    }

    @Nullable
    static DeviceProfilerService createService(@NotNull IDevice device) {
        int port = DevicePortForwarder.forward(device, 12389);
        if (port < 0) {
            return null;
        }
        return new DeviceProfilerService(device, port);
    }

    void register(@NotNull Object userKey) throws IllegalArgumentException {
        if (this.myUserKeys.contains(userKey)) {
            throw new IllegalArgumentException("Duplicate keys detected: " + userKey.toString());
        }
        this.myUserKeys.add(userKey);
    }

    boolean unregister(@NotNull Object userKey) {
        if (!this.myUserKeys.contains(userKey)) {
            throw new IllegalArgumentException("Key already unregistered: " + userKey.toString());
        }
        this.myUserKeys.remove(userKey);
        if (this.myUserKeys.isEmpty()) {
            DevicePortForwarder.removeForward(this.myDevice, this.myPort, 12389);
            ProfilerService.getInstance().stop(this);
            this.myChannel.shutdown();
            return true;
        }
        return false;
    }

    @NotNull
    DeviceServiceGrpc.DeviceServiceBlockingStub getDeviceService() {
        return this.myDeviceService;
    }

    @NotNull
    MemoryServiceGrpc.MemoryServiceBlockingStub getMemoryService() {
        return this.myMemoryService;
    }

    @NotNull
    public IDevice getDevice() {
        return this.myDevice;
    }
}

