/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.monitor.profilerclient;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.TimeoutException;
import com.intellij.openapi.diagnostic.Logger;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DevicePortForwarder {
    private static final Logger LOG = Logger.getInstance((String)DevicePortForwarder.class.getCanonicalName());
    private static final int LOCAL_PROFILER_CLIENT_PORT_RANGE_START = 46623;
    private static final int MAX_PORT = 65536;

    static synchronized int forward(@NotNull IDevice device, @NotNull String unixDomainName) {
        return DevicePortForwarder.forward(device, unixDomainName, -1);
    }

    static synchronized int forward(@NotNull IDevice device, int devicePort) {
        return DevicePortForwarder.forward(device, null, devicePort);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized int forward(@NotNull IDevice device, @Nullable String unixDomainName, int devicePort) {
        int hostPort;
        boolean isDeviceOnline = device.isOnline();
        for (hostPort = 46623; hostPort < 65536 && isDeviceOnline; ++hostPort) {
            try {
                if (unixDomainName != null) {
                    assert (devicePort < 0);
                    device.createForward(hostPort, unixDomainName, IDevice.DeviceUnixSocketNamespace.ABSTRACT);
                    break;
                }
                assert (devicePort >= 0 && devicePort <= 65536);
                device.createForward(hostPort, devicePort);
                break;
            }
            catch (TimeoutException e) {
                LOG.error("Timed out while attempting to create port forward", (Throwable)e);
                int n = -1;
                return n;
            }
            catch (AdbCommandRejectedException e) {
                LOG.error("ADB command error while attempting to create port forward", (Throwable)e);
                continue;
            }
            catch (IOException e) {
                LOG.error("IO error while attempting to create port forward", (Throwable)e);
                continue;
            }
            finally {
                isDeviceOnline &= device.isOnline();
            }
        }
        if (!isDeviceOnline) {
            LOG.error("Could not establish port forward. Device is offline.");
            return -1;
        }
        if (hostPort == 65536) {
            LOG.error("Could not establish port forward. All ports in use in valid range.");
            return -1;
        }
        return hostPort;
    }

    static synchronized void removeForward(@NotNull IDevice device, int hostPort, @NotNull String unixDomainName) {
        try {
            device.removeForward(hostPort, unixDomainName, IDevice.DeviceUnixSocketNamespace.ABSTRACT);
        }
        catch (AdbCommandRejectedException | TimeoutException | IOException throwable) {
            // empty catch block
        }
    }

    static synchronized void removeForward(@NotNull IDevice device, int hostPort, int devicePort) {
        try {
            device.removeForward(hostPort, devicePort);
        }
        catch (AdbCommandRejectedException | TimeoutException | IOException throwable) {
            // empty catch block
        }
    }
}

