/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.monitor.datastore;

import com.android.tools.adtui.Range;
import com.android.tools.idea.monitor.datastore.SeriesDataList;
import com.android.tools.idea.monitor.datastore.SeriesDataStore;
import com.android.tools.idea.monitor.datastore.SeriesDataType;
import gnu.trove.TLongArrayList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;

public final class SeriesDataStoreImpl
implements SeriesDataStore {
    private static final int GENERATE_DATA_THREAD_DELAY = 100;
    private static final DataGenerator CPU_MY_PROCESS_GENERATOR = new DataGenerator(0, 60, 10);
    private static final DataGenerator CPU_OTHER_PROCESSES_GENERATOR = new DataGenerator(0, 30, 10);
    private static final DataGenerator CPU_NUM_THREADS_GENERATOR = new DataGenerator(0, 10, 1);
    private static final DataGenerator CPU_NUM_CONNECTIONS_GENERATOR = new DataGenerator(0, 20, 2);
    private static final DataGenerator DEFAULT_DATA_GENERATOR = new DataGenerator(0, 100, 20);
    private TLongArrayList myTimingData = new TLongArrayList();
    private Map<SeriesDataType, List<Long>> myDataSeriesMap = new HashMap<SeriesDataType, List<Long>>();
    private Thread myDataThread;
    private long myStartTime;

    public SeriesDataStoreImpl() {
        this.startGeneratingData();
    }

    @Override
    public void reset() {
        if (this.myDataThread != null) {
            this.myDataThread.interrupt();
        }
    }

    @Override
    public long getLatestTime() {
        return this.myTimingData.size() > 0 ? this.myTimingData.get(this.myTimingData.size() - 1) : 0L;
    }

    @Override
    public long getTimeAtIndex(SeriesDataType type, int index) {
        return this.myTimingData.get(index);
    }

    @Override
    public int getClosestTimeIndex(SeriesDataType type, long timeValue) {
        int index = this.myTimingData.binarySearch(timeValue);
        if (index < 0) {
            index = -index - 1;
        }
        return Math.max(0, Math.min(this.myTimingData.size() - 1, index));
    }

    public Long getValueAtIndex(SeriesDataType type, int index) {
        return this.myDataSeriesMap.get((Object)type).get(index);
    }

    public SeriesDataList<Long> getSeriesData(SeriesDataType type, Range range) {
        return new SeriesDataList<Long>(range, this, type);
    }

    private void generateData() {
        this.myTimingData.add(System.currentTimeMillis() - this.myStartTime);
        block6: for (SeriesDataType type : this.myDataSeriesMap.keySet()) {
            List<Long> data = this.myDataSeriesMap.get((Object)type);
            switch (type) {
                case CPU_MY_PROCESS: {
                    data.add(CPU_MY_PROCESS_GENERATOR.next());
                    continue block6;
                }
                case CPU_OTHER_PROCESSES: {
                    data.add(CPU_OTHER_PROCESSES_GENERATOR.next());
                    continue block6;
                }
                case CPU_THREADS: {
                    data.add(CPU_NUM_THREADS_GENERATOR.next());
                    continue block6;
                }
                case NETWORK_CONNECTIONS: {
                    data.add(CPU_NUM_CONNECTIONS_GENERATOR.next());
                    continue block6;
                }
            }
            data.add(DEFAULT_DATA_GENERATOR.next());
        }
    }

    private void startGeneratingData() {
        for (SeriesDataType type : SeriesDataType.values()) {
            this.myDataSeriesMap.put(type, new ArrayList());
        }
        this.myStartTime = System.currentTimeMillis();
        this.myDataThread = new Thread(){

            @Override
            public void run() {
                try {
                    while (true) {
                        SwingUtilities.invokeLater(() -> SeriesDataStoreImpl.this.generateData());
                        Thread.sleep(100L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            }
        };
        this.myDataThread.start();
    }

    private static class DataGenerator {
        private long myNext;
        private int myMaxVariance;
        private int myMin;
        private int myMax;

        DataGenerator(int min, int max, int maxVariance) {
            this.myMin = min;
            this.myMax = max;
            this.myMaxVariance = maxVariance;
            this.myNext = DataGenerator.randomInInterval(min, max);
        }

        long next() {
            long next = this.myNext;
            this.myNext = this.getNextVal();
            return next;
        }

        private long getNextVal() {
            long next = this.myNext + DataGenerator.randomInInterval(-this.myMaxVariance, this.myMaxVariance);
            return Math.min((long)this.myMax, Math.max((long)this.myMin, next));
        }

        private static long randomInInterval(long min, long max) {
            return (long)Math.floor(Math.random() * (double)(max - min + 1L) + (double)min);
        }
    }
}

