/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.monitor.datastore;

import com.android.tools.adtui.Range;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.idea.monitor.datastore.SeriesDataStore;
import com.android.tools.idea.monitor.datastore.SeriesDataType;
import com.intellij.util.containers.ImmutableList;

public class SeriesDataList<E>
extends ImmutableList<SeriesData<E>> {
    private static final int RANGE_PADDING_MS = 1000;
    private int mStartIndex;
    private int mEndIndex;
    private SeriesDataStore mDataStore;
    private SeriesDataType mDataType;

    public SeriesDataList(Range range, SeriesDataStore dataStore, SeriesDataType dataType) {
        this.mDataStore = dataStore;
        this.mDataType = dataType;
        this.initialize(range);
    }

    public int size() {
        return this.mEndIndex - this.mStartIndex;
    }

    public SeriesData<E> get(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size());
        }
        SeriesData data = new SeriesData();
        data.x = this.mDataStore.getTimeAtIndex(this.mDataType, this.mStartIndex + index);
        data.value = this.mDataStore.getValueAtIndex(this.mDataType, this.mStartIndex + index);
        return data;
    }

    public int getIndexForTime(long time) {
        int index = this.mDataStore.getClosestTimeIndex(this.mDataType, time) - this.mStartIndex;
        return Math.max(0, Math.min(this.size() - 1, index));
    }

    private void initialize(Range range) {
        this.mStartIndex = this.mDataStore.getClosestTimeIndex(this.mDataType, (long)range.getMin() - 1000L);
        this.mEndIndex = this.mDataStore.getClosestTimeIndex(this.mDataType, (long)range.getMax() + 1000L);
    }
}

