/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat;

import com.android.ddmlib.IDevice;
import com.android.ddmlib.Log;
import com.android.tools.idea.logcat.AndroidLogcatConstants;
import com.android.tools.idea.run.LoggingReceiver;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Key;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AndroidLogcatUtils {
    private static final Logger LOG = Logger.getInstance(AndroidLogcatUtils.class);

    private AndroidLogcatUtils() {
    }

    static void clearLogcat(final @Nullable Project project, @NotNull IDevice device) {
        try {
            AndroidUtils.executeCommandOnDevice(device, "logcat -c", new LoggingReceiver(LOG), false);
        }
        catch (Exception e) {
            LOG.info((Throwable)e);
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    Messages.showErrorDialog((Project)project, (String)("Error: " + e.getMessage()), (String)AndroidBundle.message("android.logcat.error.dialog.title", new Object[0]));
                }
            });
        }
    }

    public static Key getProcessOutputType(@NotNull Log.LogLevel level) {
        switch (level) {
            case VERBOSE: {
                return AndroidLogcatConstants.VERBOSE;
            }
            case INFO: {
                return AndroidLogcatConstants.INFO;
            }
            case DEBUG: {
                return AndroidLogcatConstants.DEBUG;
            }
            case WARN: {
                return AndroidLogcatConstants.WARNING;
            }
            case ERROR: {
                return AndroidLogcatConstants.ERROR;
            }
            case ASSERT: {
                return AndroidLogcatConstants.ASSERT;
            }
        }
        return ProcessOutputTypes.STDOUT;
    }
}

