/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lang.rs;

import com.android.tools.idea.lang.rs.RenderscriptFile;
import com.android.tools.idea.lang.rs.RenderscriptLanguage;
import com.android.tools.idea.lang.rs.RenderscriptLexer;
import com.android.tools.idea.lang.rs.RenderscriptParser;
import com.android.tools.idea.lang.rs.RenderscriptTokenType;
import com.intellij.extapi.psi.ASTWrapperPsiElement;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiParser;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;

public class RenderscriptParserDefinition
implements ParserDefinition {
    private static final TokenSet WHITESPACE_TOKENS = TokenSet.create((IElementType[])new IElementType[]{TokenType.WHITE_SPACE});
    private static final TokenSet COMMENT_TOKENS = TokenSet.create((IElementType[])new IElementType[]{RenderscriptTokenType.COMMENT});
    private static final TokenSet STRING_TOKENS = TokenSet.create((IElementType[])new IElementType[]{RenderscriptTokenType.STRING});
    public static final IFileElementType FILE = new IFileElementType(Language.findInstance(RenderscriptLanguage.class));

    @NotNull
    public Lexer createLexer(Project project) {
        return new RenderscriptLexer();
    }

    public PsiParser createParser(Project project) {
        return new RenderscriptParser();
    }

    public IFileElementType getFileNodeType() {
        return FILE;
    }

    @NotNull
    public TokenSet getWhitespaceTokens() {
        return WHITESPACE_TOKENS;
    }

    @NotNull
    public TokenSet getCommentTokens() {
        return COMMENT_TOKENS;
    }

    @NotNull
    public TokenSet getStringLiteralElements() {
        return STRING_TOKENS;
    }

    @NotNull
    public PsiElement createElement(ASTNode node) {
        return new ASTWrapperPsiElement(node);
    }

    public PsiFile createFile(FileViewProvider viewProvider) {
        return new RenderscriptFile(viewProvider);
    }

    public ParserDefinition.SpaceRequirements spaceExistanceTypeBetweenTokens(ASTNode left, ASTNode right) {
        return ParserDefinition.SpaceRequirements.MUST;
    }
}

