/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lang.databinding;

import com.android.tools.idea.lang.databinding.DataBindingXmlReferenceContributor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class DefinitionReference
implements DataBindingXmlReferenceContributor.ResolvesToModelClass,
PsiReference {
    protected final TextRange myTextRange;
    protected final PsiElement myElement;
    protected final PsiElement myTarget;

    public DefinitionReference(@NotNull PsiElement element, PsiElement resolveTo) {
        this(element, resolveTo, DefinitionReference.getElementRange(element));
    }

    @NotNull
    private static TextRange getElementRange(@NotNull PsiElement element) {
        int startOffsetInParent = element.getParent().getStartOffsetInParent();
        return startOffsetInParent > 0 ? element.getTextRange().shiftRight(-startOffsetInParent) : element.getTextRange();
    }

    public DefinitionReference(@NotNull PsiElement element, PsiElement resolveTo, @NotNull TextRange range) {
        this.myElement = element;
        this.myTarget = resolveTo;
        this.myTextRange = range;
    }

    public PsiElement getElement() {
        return this.myElement;
    }

    public TextRange getRangeInElement() {
        return this.myTextRange;
    }

    @Nullable
    public PsiElement resolve() {
        return this.myTarget;
    }

    @NotNull
    public String getCanonicalText() {
        return this.myElement.getText();
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        return null;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        return null;
    }

    public boolean isReferenceTo(PsiElement element) {
        return this.myElement.getManager().areElementsEquivalent(this.resolve(), element);
    }

    @NotNull
    public Object[] getVariants() {
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    public boolean isSoft() {
        return false;
    }
}

