/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.variant.view;

import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.Variant;
import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.ui.LabeledComboBoxAction;
import com.google.common.collect.Lists;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.ScalableIcon;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.mxgraph.canvas.mxICanvas;
import com.mxgraph.canvas.mxImageCanvas;
import com.mxgraph.layout.mxCircleLayout;
import com.mxgraph.model.mxCell;
import com.mxgraph.model.mxGraphModel;
import com.mxgraph.model.mxIGraphModel;
import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.swing.util.mxGraphTransferable;
import com.mxgraph.swing.view.mxInteractiveCanvas;
import com.mxgraph.view.mxCellState;
import com.mxgraph.view.mxGraph;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

class ModuleVariantsInfoGraph
extends DialogWrapper {
    @NotNull
    private final Module myModule;
    @NotNull
    private final AndroidGradleModel myAndroidModel;
    @NotNull
    private Variant mySelectedVariant;
    private mxGraphComponent myGraphComponent;
    private VariantGraph myGraph;

    ModuleVariantsInfoGraph(@NotNull Module module) {
        super(module.getProject());
        this.myModule = module;
        AndroidGradleModel androidModel = AndroidGradleModel.get(this.myModule);
        assert (androidModel != null);
        this.myAndroidModel = androidModel;
        this.mySelectedVariant = this.myAndroidModel.getSelectedVariant();
        this.setTitle(String.format("Dependency Details for Module '%1$s'", this.myModule.getName()));
        this.init();
    }

    @NotNull
    protected JComponent createCenterPanel() {
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.setPreferredSize((Dimension)JBUI.size((int)600, (int)400));
        DefaultActionGroup group = new DefaultActionGroup(new AnAction[]{new VariantsComboBoxAction(), Separator.getInstance(), new ResetLayoutAction(), new ShowGridAction(), Separator.getInstance(), new ZoomInAction(), new ZoomOutAction(), new ZoomActualAction()});
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("TOP", (ActionGroup)group, true);
        mainPanel.add((Component)toolbar.getComponent(), "North");
        this.myGraph = new VariantGraph();
        this.myGraphComponent = new mxGraphComponent(this.myGraph){

            public mxInteractiveCanvas createCanvas() {
                return new CustomCanvas(ModuleVariantsInfoGraph.this.myModule.getProject(), this);
            }
        };
        this.myGraphComponent.setGridVisible(true);
        this.myGraphComponent.setToolTips(false);
        mainPanel.add((Component)this.myGraphComponent, "Center");
        this.myGraph.render(this.myModule, this.myAndroidModel, this.mySelectedVariant);
        return mainPanel;
    }

    private class ZoomActualAction
    extends DumbAwareAction {
        ZoomActualAction() {
            super("Actual Size", null, AllIcons.Graph.ActualZoom);
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setEnabled(ModuleVariantsInfoGraph.this.myGraphComponent != null);
        }

        public void actionPerformed(AnActionEvent e) {
            if (ModuleVariantsInfoGraph.this.myGraphComponent != null) {
                ModuleVariantsInfoGraph.this.myGraphComponent.zoomActual();
            }
        }
    }

    private class ZoomOutAction
    extends DumbAwareAction {
        ZoomOutAction() {
            super("Zoom Out", null, AllIcons.Graph.ZoomOut);
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setEnabled(ModuleVariantsInfoGraph.this.myGraphComponent != null);
        }

        public void actionPerformed(AnActionEvent e) {
            if (ModuleVariantsInfoGraph.this.myGraphComponent != null) {
                ModuleVariantsInfoGraph.this.myGraphComponent.zoomOut();
            }
        }
    }

    private class ZoomInAction
    extends DumbAwareAction {
        ZoomInAction() {
            super("Zoom In", null, AllIcons.Graph.ZoomIn);
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setEnabled(ModuleVariantsInfoGraph.this.myGraphComponent != null);
        }

        public void actionPerformed(AnActionEvent e) {
            if (ModuleVariantsInfoGraph.this.myGraphComponent != null) {
                ModuleVariantsInfoGraph.this.myGraphComponent.zoomIn();
            }
        }
    }

    private class ResetLayoutAction
    extends DumbAwareAction {
        ResetLayoutAction() {
            super("Reset Layout", null, AllIcons.Graph.Layout);
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setEnabled(ModuleVariantsInfoGraph.this.myGraph != null);
        }

        public void actionPerformed(AnActionEvent e) {
            if (ModuleVariantsInfoGraph.this.myGraph != null) {
                ModuleVariantsInfoGraph.this.myGraph.resetLayout();
            }
        }
    }

    private class ShowGridAction
    extends ToggleAction {
        ShowGridAction() {
            super("Show/Hide Grid", null, AllIcons.Graph.Grid);
        }

        public void update(@NotNull AnActionEvent e) {
            super.update(e);
            e.getPresentation().setEnabled(ModuleVariantsInfoGraph.this.myGraphComponent != null);
        }

        public boolean isSelected(AnActionEvent e) {
            return ModuleVariantsInfoGraph.this.myGraphComponent != null && ModuleVariantsInfoGraph.this.myGraphComponent.isGridVisible();
        }

        public void setSelected(AnActionEvent e, boolean state) {
            if (ModuleVariantsInfoGraph.this.myGraphComponent != null) {
                ModuleVariantsInfoGraph.this.myGraphComponent.setGridVisible(state);
                ModuleVariantsInfoGraph.this.myGraphComponent.refresh();
            }
        }
    }

    private class VariantSelectionAction
    extends DumbAwareAction {
        @NotNull
        private final Variant myVariant;

        VariantSelectionAction(Variant variant) {
            super(variant.getName());
            this.myVariant = variant;
        }

        public void actionPerformed(AnActionEvent e) {
            ModuleVariantsInfoGraph.this.mySelectedVariant = this.myVariant;
            ModuleVariantsInfoGraph.this.myGraph.render(ModuleVariantsInfoGraph.this.myModule, ModuleVariantsInfoGraph.this.myAndroidModel, ModuleVariantsInfoGraph.this.mySelectedVariant);
            ModuleVariantsInfoGraph.this.myGraphComponent.refresh();
        }
    }

    private class VariantsComboBoxAction
    extends LabeledComboBoxAction {
        VariantsComboBoxAction() {
            super("Variant: ");
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setText(ModuleVariantsInfoGraph.this.mySelectedVariant.getName());
        }

        @NotNull
        protected DefaultActionGroup createPopupActionGroup(JComponent button) {
            ArrayList actions = Lists.newArrayList();
            for (Variant variant : ModuleVariantsInfoGraph.this.myAndroidModel.getAndroidProject().getVariants()) {
                actions.add(new VariantSelectionAction(variant));
            }
            return new DefaultActionGroup((List)actions);
        }
    }

    private static class CustomCanvas
    extends mxInteractiveCanvas {
        @NotNull
        private final Project myProject;
        @NotNull
        private final mxGraphComponent myGraphComponent;
        @NotNull
        private final JBLabel myVertexRenderer = new JBLabel();

        CustomCanvas(@NotNull Project project, @NotNull mxGraphComponent graphComponent) {
            this.myProject = project;
            this.myGraphComponent = graphComponent;
            this.myVertexRenderer.setOpaque(true);
            this.myVertexRenderer.setBackground(JBColor.background());
            this.myVertexRenderer.setForeground(JBColor.foreground());
            this.myVertexRenderer.setBorder(BorderFactory.createLineBorder(JBColor.border(), 1));
            this.myVertexRenderer.setHorizontalTextPosition(4);
            this.myVertexRenderer.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        }

        void drawVertex(@NotNull mxCellState cellState, boolean drawLabel) {
            String text;
            mxCell cell = (mxCell)cellState.getCell();
            Object value = cell.getValue();
            Icon icon = null;
            if (value instanceof ModuleVertexModel) {
                ModuleVertexModel model = (ModuleVertexModel)value;
                text = drawLabel ? model.name : "";
                Module module = ModuleManager.getInstance((Project)this.myProject).findModuleByName(model.name);
                assert (module != null);
                icon = GradleUtil.getModuleIcon(module);
            } else {
                text = drawLabel ? cellState.getLabel() : "";
            }
            int w = (int)cellState.getWidth();
            int h = (int)cellState.getHeight();
            float scale = JBUI.scale((float)((float)this.getScale()));
            float defaultFontSize = UIUtil.getFontSize((UIUtil.FontSize)UIUtil.FontSize.SMALL);
            Font newFont = this.myVertexRenderer.getFont().deriveFont(defaultFontSize * scale);
            this.myVertexRenderer.setFont(newFont);
            if (icon instanceof ScalableIcon) {
                ScalableIcon scalableIcon = (ScalableIcon)icon;
                icon = scalableIcon.scale(scale);
            }
            this.myVertexRenderer.setText(text);
            this.myVertexRenderer.setIcon(icon);
            this.myVertexRenderer.setSize(w, h);
            this.rendererPane.paintComponent(this.g, (Component)this.myVertexRenderer, (Container)this.myGraphComponent, (int)cellState.getX() + this.translate.x, (int)cellState.getY() + this.translate.y, w, h, true);
        }
    }

    private static class ModuleVertexModel
    implements Serializable {
        @NotNull
        String name;

        ModuleVertexModel(@NotNull String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    private static class VariantGraph
    extends mxGraph {
        private static final double VERTEX_WIDTH = 100.0;
        private static final double VERTEX_HEIGHT = 30.0;

        VariantGraph() {
            this.setCellsCloneable(false);
            this.setCellsDeletable(false);
            this.setCellsDisconnectable(false);
            this.setCellsEditable(false);
            this.setCellsResizable(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void render(@NotNull Module module, @NotNull AndroidGradleModel androidModel, @NotNull Variant variant) {
            this.setModel((mxIGraphModel)new mxGraphModel());
            mxIGraphModel model = this.getModel();
            model.beginUpdate();
            try {
                mxCell parent = (mxCell)this.getDefaultParent();
                mxCell moduleVertex = this.createVertex(module);
                moduleVertex.setConnectable(false);
                for (AndroidLibrary library : GradleUtil.getDirectLibraryDependencies(variant, androidModel)) {
                    Module dependency;
                    String gradlePath = library.getProject();
                    if (gradlePath == null || (dependency = GradleUtil.findModuleByGradlePath(module.getProject(), gradlePath)) == null) continue;
                    mxCell dependencyVertex = this.createVertex(dependency);
                    dependencyVertex.setConnectable(false);
                    String projectVariant = StringUtil.notNullize((String)library.getProjectVariant());
                    this.insertEdge(parent, null, projectVariant, moduleVertex, dependencyVertex);
                }
            }
            finally {
                model.endUpdate();
            }
            this.resetLayout();
        }

        @NotNull
        private mxCell createVertex(@NotNull Module module) {
            ModuleVertexModel model = new ModuleVertexModel(module.getName());
            return (mxCell)this.insertVertex(this.getDefaultParent(), null, model, 0.0, 0.0, 100.0, 30.0);
        }

        void resetLayout() {
            mxCircleLayout layout = new mxCircleLayout((mxGraph)this);
            layout.setDisableEdgeStyle(false);
            layout.execute(this.getDefaultParent());
        }

        public void drawState(mxICanvas canvas, mxCellState state, boolean drawLabel) {
            mxIGraphModel model = this.getModel();
            boolean vertex = model.isVertex(state.getCell());
            if (vertex && canvas instanceof mxImageCanvas && ((mxImageCanvas)canvas).getGraphicsCanvas() != null) {
                ((CustomCanvas)((mxImageCanvas)canvas).getGraphicsCanvas()).drawVertex(state, drawLabel);
                return;
            }
            if (vertex && canvas instanceof CustomCanvas) {
                ((CustomCanvas)canvas).drawVertex(state, drawLabel);
                return;
            }
            super.drawState(canvas, state, drawLabel);
        }

        static {
            mxGraphTransferable.enableImageSupport = false;
        }
    }
}

