/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.util;

import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FilePaths {
    private FilePaths() {
    }

    @Nullable
    public static ContentEntry findParentContentEntry(@NotNull File path, @NotNull ContentEntry[] contentEntries) {
        for (ContentEntry contentEntry : contentEntries) {
            if (!FilePaths.isPathInContentEntry(path, contentEntry)) continue;
            return contentEntry;
        }
        return null;
    }

    @Nullable
    public static ContentEntry findParentContentEntry(@NotNull File path, @NotNull Collection<ContentEntry> contentEntries) {
        for (ContentEntry contentEntry : contentEntries) {
            if (!FilePaths.isPathInContentEntry(path, contentEntry)) continue;
            return contentEntry;
        }
        return null;
    }

    public static boolean isPathInContentEntry(@NotNull File path, @NotNull ContentEntry contentEntry) {
        File rootFilePath;
        VirtualFile rootFile = contentEntry.getFile();
        if (rootFile == null) {
            String s = VfsUtilCore.urlToPath((String)contentEntry.getUrl());
            rootFilePath = new File(s);
        } else {
            rootFilePath = VfsUtilCore.virtualToIoFile((VirtualFile)rootFile);
        }
        return FileUtil.isAncestor((File)rootFilePath, (File)path, (boolean)false);
    }

    @NotNull
    public static String pathToIdeaUrl(@NotNull File path) {
        return VfsUtilCore.pathToUrl((String)FileUtil.toSystemIndependentName((String)path.getPath()));
    }

    @Nullable
    public static File getJarFromJarUrl(@NotNull String url) {
        if (!url.startsWith("jar://")) {
            return null;
        }
        String path = url.substring("jar://".length());
        int index = path.lastIndexOf("!/");
        if (index != -1) {
            path = path.substring(0, index);
        }
        return new File(FileUtil.toSystemDependentName((String)path));
    }
}

