/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.util;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetTypeId;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Facets {
    private Facets() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends Facet> void removeAllFacetsOfType(@NotNull Module module, @NotNull FacetTypeId<T> typeId) {
        FacetManager facetManager = FacetManager.getInstance((Module)module);
        Collection facets = facetManager.getFacetsByType(typeId);
        if (!facets.isEmpty()) {
            ModifiableFacetModel model = facetManager.createModifiableModel();
            try {
                for (Facet facet : facets) {
                    model.removeFacet(facet);
                }
            }
            finally {
                model.commit();
            }
        }
    }

    public static <T extends Facet> void removeAllFacetsOfType(@NotNull FacetTypeId<T> typeId, @NotNull ModifiableFacetModel modifiableFacetModel) {
        Collection facets = modifiableFacetModel.getFacetsByType(typeId);
        if (!facets.isEmpty()) {
            for (Facet facet : facets) {
                modifiableFacetModel.removeFacet(facet);
            }
        }
    }

    @Nullable
    public static <T extends Facet> T findFacet(@NotNull Module module, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull FacetTypeId<T> typeId) {
        Facet facet = FacetManager.getInstance((Module)module).getFacetByType(typeId);
        if (facet == null) {
            ModifiableFacetModel facetModel = modelsProvider.getModifiableFacetModel(module);
            facet = facetModel.getFacetByType(typeId);
        }
        return (T)facet;
    }
}

