/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.util;

import com.google.common.collect.ImmutableList;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EmbeddedDistributionPaths {
    private static final Logger LOG = Logger.getInstance(EmbeddedDistributionPaths.class);

    @NotNull
    public static List<File> findAndroidStudioLocalMavenRepoPaths() {
        String relativePath;
        File repoPath;
        File defaultRootDirPath = EmbeddedDistributionPaths.getDefaultRootDirPath();
        if (defaultRootDirPath != null) {
            File repoPath2 = new File(defaultRootDirPath, "m2repository");
            return repoPath2.isDirectory() ? ImmutableList.of((Object)repoPath2) : ImmutableList.of();
        }
        LinkedList<File> repoPaths = new LinkedList<File>();
        String studioCustomRepo = System.getenv("STUDIO_CUSTOM_REPO");
        if (studioCustomRepo != null) {
            repoPath = new File(FileUtil.toCanonicalPath((String)FileUtil.toSystemDependentName((String)studioCustomRepo)));
            if (!repoPath.isDirectory()) {
                throw new IllegalArgumentException("Invalid path in STUDIO_CUSTOM_REPO environment variable");
            }
        } else {
            relativePath = FileUtil.toSystemDependentName((String)"/../../prebuilts/tools/common/offline-m2");
            repoPath = new File(FileUtil.toCanonicalPath((String)(EmbeddedDistributionPaths.getIdeHomePath() + relativePath)));
        }
        LOG.info("Looking for embedded Maven repo at '" + repoPath.getPath() + "'");
        if (repoPath.isDirectory()) {
            repoPaths.add(repoPath);
        }
        relativePath = FileUtil.toSystemDependentName((String)"/../../out/studio/repo");
        repoPath = new File(PathManager.getHomePath() + relativePath);
        if (repoPath.isDirectory()) {
            repoPaths.add(repoPath);
        }
        return repoPaths;
    }

    @Nullable
    public static File findEmbeddedGradleDistributionPath() {
        File distributionPath = EmbeddedDistributionPaths.getDefaultRootDirPath();
        if (distributionPath != null) {
            File embeddedPath = new File(distributionPath, "gradle-2.14.1");
            LOG.info("Looking for embedded Gradle distribution at '" + embeddedPath.getPath() + "'");
            if (embeddedPath.isDirectory()) {
                LOG.info("Found embedded Gradle 2.14.1");
                return embeddedPath;
            }
            LOG.info("Unable to find embedded Gradle 2.14.1");
            return null;
        }
        String ideHomePath = EmbeddedDistributionPaths.getIdeHomePath();
        String relativePath = FileUtil.toSystemDependentName((String)"/../../out/gradle-dist-link");
        distributionPath = new File(FileUtil.toCanonicalPath((String)(ideHomePath + relativePath)));
        return distributionPath.isDirectory() ? distributionPath : null;
    }

    @Nullable
    private static File getDefaultRootDirPath() {
        String ideHomePath = EmbeddedDistributionPaths.getIdeHomePath();
        File rootDirPath = new File(ideHomePath, "gradle");
        return rootDirPath.isDirectory() ? rootDirPath : null;
    }

    @NotNull
    public static File getEmbeddedJdkPath() {
        String ideHomePath = EmbeddedDistributionPaths.getIdeHomePath();
        File jdkRootPath = new File(ideHomePath, SystemInfo.isMac ? FileUtil.join((String[])new String[]{"jre", "jdk"}) : "jre");
        if (jdkRootPath.isDirectory()) {
            return EmbeddedDistributionPaths.getSystemSpecificJdkPath(jdkRootPath);
        }
        String relativePath = FileUtil.toSystemDependentName((String)"/../../prebuilts/studio/jdk");
        jdkRootPath = new File(FileUtil.toCanonicalPath((String)(ideHomePath + relativePath)));
        if (SystemInfo.isWindows) {
            jdkRootPath = new File(jdkRootPath, "win64");
        } else if (SystemInfo.isLinux) {
            jdkRootPath = new File(jdkRootPath, "linux");
        } else if (SystemInfo.isMac) {
            jdkRootPath = new File(jdkRootPath, "mac");
        }
        return EmbeddedDistributionPaths.getSystemSpecificJdkPath(jdkRootPath);
    }

    @NotNull
    private static File getSystemSpecificJdkPath(File jdkRootPath) {
        if (SystemInfo.isMac) {
            jdkRootPath = new File(jdkRootPath, "/Contents/Home");
        }
        assert (jdkRootPath.isDirectory());
        return jdkRootPath;
    }

    @NotNull
    private static String getIdeHomePath() {
        return FileUtil.toSystemDependentName((String)PathManager.getHomePath());
    }
}

