/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.services;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.tools.idea.gradle.dsl.model.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.ArtifactDependencyModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.ArtifactDependencySpec;
import com.android.tools.idea.gradle.dsl.model.dependencies.DependenciesModel;
import com.android.tools.idea.gradle.project.GradleProjectImporter;
import com.android.tools.idea.gradle.project.GradleSyncListener;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.structure.services.DeveloperServiceBuildSystemOperations;
import com.android.tools.idea.structure.services.DeveloperServiceMetadata;
import com.android.tools.idea.templates.RepositoryUrlManager;
import com.google.common.collect.Lists;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.util.text.VersionComparatorUtil;
import java.util.ArrayList;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleOperations
implements DeveloperServiceBuildSystemOperations {
    @Override
    public boolean canHandle(@NotNull Project project) {
        return Projects.isBuildWithGradle(project);
    }

    @Override
    public boolean containsAllDependencies(@NotNull Module module, @NotNull DeveloperServiceMetadata metadata) {
        DependenciesModel dependenciesModel;
        ArrayList moduleDependencyNames = Lists.newArrayList();
        GradleBuildModel buildModel = GradleBuildModel.get(module);
        if (buildModel != null && (dependenciesModel = buildModel.dependencies()) != null) {
            for (ArtifactDependencyModel dependency : dependenciesModel.artifacts()) {
                String name = dependency.name().value();
                moduleDependencyNames.add(name);
            }
        }
        boolean allDependenciesFound = true;
        for (String serviceDependency : metadata.getDependencies()) {
            boolean thisDependencyFound = false;
            for (String moduleDependencyName : moduleDependencyNames) {
                if (!serviceDependency.contains(moduleDependencyName)) continue;
                thisDependencyFound = true;
                break;
            }
            if (thisDependencyFound) continue;
            allDependenciesFound = false;
            break;
        }
        return allDependenciesFound;
    }

    @Override
    public boolean isServiceInstalled(@NotNull Module module, @NotNull DeveloperServiceMetadata metadata) {
        DependenciesModel dependenciesModel;
        GradleBuildModel buildModel = GradleBuildModel.get(module);
        if (buildModel != null && (dependenciesModel = buildModel.dependencies()) != null) {
            for (ArtifactDependencyModel dependency : dependenciesModel.artifacts()) {
                ArtifactDependencySpec spec = ArtifactDependencySpec.create(dependency);
                for (String dependencyValue : metadata.getDependencies()) {
                    ArtifactDependencySpec value = ArtifactDependencySpec.create(dependencyValue);
                    if (!value.equalsIgnoreVersion(spec) || VersionComparatorUtil.compare((String)spec.version, (String)value.version) < 0) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public void removeDependencies(@NotNull Module module, @NotNull DeveloperServiceMetadata metadata) {
        final GradleBuildModel buildModel = GradleBuildModel.get(module);
        if (buildModel != null) {
            boolean dependenciesChanged = false;
            DependenciesModel dependenciesModel = buildModel.dependencies();
            if (dependenciesModel != null) {
                block0: for (ArtifactDependencyModel dependency : dependenciesModel.artifacts()) {
                    ArtifactDependencySpec spec = ArtifactDependencySpec.create(dependency);
                    for (String dependencyValue : metadata.getDependencies()) {
                        if (!spec.equals(ArtifactDependencySpec.create(dependencyValue))) continue;
                        dependenciesModel.remove(dependency);
                        dependenciesChanged = true;
                        continue block0;
                    }
                }
            }
            Project project = module.getProject();
            if (dependenciesChanged) {
                new WriteCommandAction.Simple(project, "Uninstall " + metadata.getName(), new PsiFile[0]){

                    public void run() {
                        buildModel.applyChanges();
                    }
                }.execute();
            }
            GradleProjectImporter.getInstance().requestProjectSync(project, null);
        }
    }

    @Override
    public void initializeServices(@NotNull Module module, final @NotNull Runnable initializationTask) {
        AndroidFacet facet = AndroidFacet.getInstance(module);
        assert (facet != null);
        facet.addListener(new GradleSyncListener.Adapter(){

            @Override
            public void syncSucceeded(@NotNull Project project) {
                initializationTask.run();
            }
        });
    }

    @Override
    @NotNull
    public String getBuildSystemId() {
        return "Gradle";
    }

    @Override
    @Nullable
    public String getHighestVersion(@NotNull String groupId, @NotNull String artifactId) {
        GradleCoordinate gradleCoordinate = new GradleCoordinate(groupId, artifactId, new GradleCoordinate.RevisionComponent[]{GradleCoordinate.PLUS_REV});
        return RepositoryUrlManager.get().resolveDynamicCoordinateVersion(gradleCoordinate, null);
    }
}

