/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.navigation;

import com.android.tools.idea.gradle.structure.configurables.DependenciesPerspectiveConfigurable;
import com.android.tools.idea.gradle.structure.configurables.PsContext;
import com.android.tools.idea.gradle.structure.model.PsArtifactDependencySpec;
import com.android.tools.idea.gradle.structure.model.PsDependency;
import com.android.tools.idea.gradle.structure.model.PsLibraryDependency;
import com.android.tools.idea.gradle.structure.model.PsPath;
import com.android.tools.idea.gradle.structure.navigation.Places;
import com.android.tools.idea.structure.dialog.ProjectStructureConfigurable;
import com.google.common.base.Objects;
import com.intellij.openapi.options.Configurable;
import com.intellij.ui.navigation.Place;
import org.jetbrains.annotations.NotNull;

public class PsLibraryDependencyNavigationPath
extends PsPath {
    @NotNull
    private final PsContext myContext;
    @NotNull
    private final String myModuleName;
    @NotNull
    private final String myDependency;
    @NotNull
    private final String myNavigationText;

    public PsLibraryDependencyNavigationPath(@NotNull PsContext context, @NotNull PsLibraryDependency dependency) {
        this.myContext = context;
        this.myModuleName = dependency.getParent().getName();
        PsArtifactDependencySpec spec = dependency.getDeclaredSpec();
        if (spec == null) {
            spec = dependency.getResolvedSpec();
        }
        this.myNavigationText = dependency.toText(PsDependency.TextType.FOR_NAVIGATION);
        this.myDependency = spec.name + ":" + spec.version;
    }

    @Override
    @NotNull
    public String toText(@NotNull PsPath.TexType type) {
        switch (type) {
            case PLAIN_TEXT: {
                return this.myDependency;
            }
            case HTML: {
                return this.getHtmlText();
            }
            case FOR_COMPARE_TO: {
                return this.myDependency + " / " + this.myModuleName;
            }
        }
        return "";
    }

    @NotNull
    private String getHtmlText() {
        Place place = new Place();
        ProjectStructureConfigurable mainConfigurable = this.myContext.getMainConfigurable();
        DependenciesPerspectiveConfigurable target = mainConfigurable.findConfigurable(DependenciesPerspectiveConfigurable.class);
        assert (target != null);
        ProjectStructureConfigurable.putPath(place, (Configurable)target);
        target.putNavigationPath(place, this.myModuleName, this.myNavigationText);
        String href = "psdGoTo://" + Places.serialize(place);
        return String.format("<a href='%1$s'>%2$s</a> (%3$s)", href, this.myDependency, this.myModuleName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PsLibraryDependencyNavigationPath that = (PsLibraryDependencyNavigationPath)o;
        return Objects.equal((Object)this.myModuleName, (Object)that.myModuleName) && Objects.equal((Object)this.myDependency, (Object)that.myDependency) && Objects.equal((Object)this.myNavigationText, (Object)that.myNavigationText);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.myModuleName, this.myDependency, this.myNavigationText});
    }
}

