/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.model.java;

import com.android.tools.idea.gradle.dsl.model.dependencies.ArtifactDependencyModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.DependencyModel;
import com.android.tools.idea.gradle.model.java.JarLibraryDependency;
import com.android.tools.idea.gradle.structure.model.PsArtifactDependencySpec;
import com.android.tools.idea.gradle.structure.model.PsDependency;
import com.android.tools.idea.gradle.structure.model.PsLibraryDependency;
import com.android.tools.idea.gradle.structure.model.java.PsJavaDependency;
import com.android.tools.idea.gradle.structure.model.java.PsJavaModule;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.intellij.util.PlatformIcons;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsLibraryJavaDependency
extends PsJavaDependency
implements PsLibraryDependency {
    @NotNull
    private final List<PsArtifactDependencySpec> myPomDependencies = Lists.newArrayList();
    @NotNull
    private PsArtifactDependencySpec myResolvedSpec;
    @Nullable
    private final JarLibraryDependency myResolvedModel;
    @Nullable
    private PsArtifactDependencySpec myDeclaredSpec;

    protected PsLibraryJavaDependency(@NotNull PsJavaModule parent, @NotNull PsArtifactDependencySpec resolvedSpec, @Nullable JarLibraryDependency resolvedModel, @Nullable ArtifactDependencyModel parsedModel) {
        super(parent, (DependencyModel)parsedModel);
        this.myResolvedSpec = resolvedSpec;
        this.myResolvedModel = resolvedModel;
        if (parsedModel != null) {
            this.setDeclaredSpec(this.createSpec(parsedModel));
        }
    }

    @Override
    @Nullable
    public PsArtifactDependencySpec getDeclaredSpec() {
        return this.myDeclaredSpec;
    }

    @Override
    @NotNull
    public PsArtifactDependencySpec getResolvedSpec() {
        return this.myResolvedSpec;
    }

    @Override
    public boolean hasPromotedVersion() {
        return false;
    }

    @Override
    @NotNull
    public String toText(@NotNull PsDependency.TextType type) {
        switch (type) {
            case PLAIN_TEXT: {
                return this.myResolvedSpec.toString();
            }
            case FOR_NAVIGATION: {
                PsArtifactDependencySpec spec = this.myDeclaredSpec;
                if (spec == null) {
                    spec = this.myResolvedSpec;
                }
                return spec.toString();
            }
        }
        return "";
    }

    @Override
    @NotNull
    public ImmutableCollection<PsDependency> getTransitiveDependencies() {
        return ImmutableList.of();
    }

    void setDependenciesFromPomFile(@NotNull List<PsArtifactDependencySpec> pomDependencies) {
        this.myPomDependencies.clear();
        this.myPomDependencies.addAll(pomDependencies);
    }

    @Override
    public void setResolvedSpec(@NotNull PsArtifactDependencySpec spec) {
        this.myResolvedSpec = spec;
    }

    @Override
    public void setDeclaredSpec(@NotNull PsArtifactDependencySpec spec) {
        this.myDeclaredSpec = spec;
    }

    @Override
    @NotNull
    public String getName() {
        return this.myResolvedSpec.name;
    }

    @Override
    @NotNull
    public Icon getIcon() {
        return PlatformIcons.LIBRARY_ICON;
    }

    @Override
    @Nullable
    public JarLibraryDependency getResolvedModel() {
        return this.myResolvedModel;
    }
}

