/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.model.android;

import com.android.tools.idea.gradle.structure.model.android.PsAndroidArtifact;
import com.android.tools.idea.gradle.structure.model.android.PsAndroidModule;
import com.android.tools.idea.gradle.structure.model.android.PsVariant;
import com.google.common.base.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsDependencyContainer {
    @NotNull
    private final String myVariant;
    @NotNull
    private final String myArtifact;
    @NotNull
    private final String myName;

    PsDependencyContainer(@NotNull PsAndroidArtifact artifact) {
        PsVariant variant = artifact.getParent();
        this.myVariant = variant.getName();
        this.myArtifact = artifact.getResolvedName();
        this.myName = PsDependencyContainer.createName(this.myVariant, this.myArtifact);
    }

    public PsDependencyContainer(@NotNull String variant, @NotNull String artifact) {
        this.myVariant = variant;
        this.myArtifact = artifact;
        this.myName = PsDependencyContainer.createName(this.myVariant, this.myArtifact);
    }

    @NotNull
    private static String createName(@NotNull String variant, @NotNull String artifact) {
        return variant + " " + artifact;
    }

    @Contract(value="_, true -> !null")
    @Nullable
    public PsAndroidArtifact findArtifact(@NotNull PsAndroidModule module, boolean mustExist) {
        PsVariant variant = module.findVariant(this.myVariant);
        if (variant == null && !mustExist) {
            return null;
        }
        assert (variant != null);
        PsAndroidArtifact artifact = variant.findArtifact(this.myArtifact);
        if (artifact == null && !mustExist) {
            return null;
        }
        assert (artifact != null);
        return artifact;
    }

    @NotNull
    public String getName() {
        return this.myName;
    }

    @NotNull
    public String getVariant() {
        return this.myVariant;
    }

    @NotNull
    public String getArtifact() {
        return this.myArtifact;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PsDependencyContainer container = (PsDependencyContainer)o;
        return Objects.equal((Object)this.myVariant, (Object)container.myVariant) && Objects.equal((Object)this.myArtifact, (Object)container.myArtifact);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.myVariant, this.myArtifact});
    }

    public String toString() {
        return this.getName();
    }
}

