/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.model.android;

import com.android.builder.model.BuildType;
import com.android.builder.model.BuildTypeContainer;
import com.android.tools.idea.gradle.dsl.model.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.model.android.BuildTypeModel;
import com.android.tools.idea.gradle.structure.model.PsModelCollection;
import com.android.tools.idea.gradle.structure.model.android.PsAndroidModule;
import com.android.tools.idea.gradle.structure.model.android.PsBuildType;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsBuildTypeCollection
implements PsModelCollection<PsBuildType> {
    @NotNull
    private final Map<String, PsBuildType> myBuildTypesByName = Maps.newHashMap();

    PsBuildTypeCollection(@NotNull PsAndroidModule parent) {
        HashMap buildTypesFromGradle = Maps.newHashMap();
        for (BuildTypeContainer container : parent.getGradleModel().getAndroidProject().getBuildTypes()) {
            Object buildType = container.getBuildType();
            buildTypesFromGradle.put(buildType.getName(), buildType);
        }
        GradleBuildModel parsedModel = parent.getParsedModel();
        if (parsedModel != null) {
            Collection<BuildTypeModel> parsedBuildTypes = parsedModel.android().buildTypes();
            for (BuildTypeModel parsedBuildType : parsedBuildTypes) {
                String name = parsedBuildType.name();
                BuildType fromGradle = (BuildType)buildTypesFromGradle.remove(name);
                PsBuildType model = new PsBuildType(parent, fromGradle, parsedBuildType);
                this.myBuildTypesByName.put(name, model);
            }
        }
        if (!buildTypesFromGradle.isEmpty()) {
            for (Object buildType : buildTypesFromGradle.values()) {
                PsBuildType model = new PsBuildType(parent, (BuildType)buildType, null);
                this.myBuildTypesByName.put(buildType.getName(), model);
            }
        }
    }

    @Override
    @Nullable
    public <S extends PsBuildType> S findElement(@NotNull String name, @NotNull Class<S> type) {
        if (PsBuildType.class.equals(type)) {
            return (S)((PsBuildType)type.cast(this.myBuildTypesByName.get(name)));
        }
        return null;
    }

    @Override
    public void forEach(@NotNull Consumer<PsBuildType> consumer) {
        this.myBuildTypesByName.values().forEach(consumer);
    }
}

