/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.model.android;

import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.ArtifactDependencyModel;
import com.android.tools.idea.gradle.structure.model.PsArtifactDependencySpec;
import com.android.tools.idea.gradle.structure.model.PsModule;
import com.android.tools.idea.gradle.structure.model.PsParsedDependencies;
import com.android.tools.idea.gradle.structure.model.PsProject;
import com.android.tools.idea.gradle.structure.model.android.PsAndroidArtifact;
import com.android.tools.idea.gradle.structure.model.android.PsAndroidDependency;
import com.android.tools.idea.gradle.structure.model.android.PsAndroidDependencyCollection;
import com.android.tools.idea.gradle.structure.model.android.PsAndroidModel;
import com.android.tools.idea.gradle.structure.model.android.PsBuildType;
import com.android.tools.idea.gradle.structure.model.android.PsBuildTypeCollection;
import com.android.tools.idea.gradle.structure.model.android.PsLibraryAndroidDependency;
import com.android.tools.idea.gradle.structure.model.android.PsModuleAndroidDependency;
import com.android.tools.idea.gradle.structure.model.android.PsProductFlavor;
import com.android.tools.idea.gradle.structure.model.android.PsProductFlavorCollection;
import com.android.tools.idea.gradle.structure.model.android.PsVariant;
import com.android.tools.idea.gradle.structure.model.android.PsVariantCollection;
import com.android.tools.idea.gradle.structure.model.android.dependency.PsNewDependencyScopes;
import com.android.tools.idea.gradle.structure.model.repositories.search.AndroidSdkRepositories;
import com.android.tools.idea.gradle.structure.model.repositories.search.ArtifactRepository;
import com.google.common.collect.Lists;
import com.intellij.openapi.module.Module;
import icons.AndroidIcons;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsAndroidModule
extends PsModule
implements PsAndroidModel {
    @NotNull
    private final AndroidGradleModel myGradleModel;
    private PsBuildTypeCollection myBuildTypeCollection;
    private PsProductFlavorCollection myProductFlavorCollection;
    private PsVariantCollection myVariantCollection;
    private PsAndroidDependencyCollection myDependencyCollection;

    public PsAndroidModule(@NotNull PsProject parent, @NotNull Module resolvedModel, @NotNull String gradlePath, @NotNull AndroidGradleModel gradleModel) {
        super(parent, resolvedModel, gradlePath);
        this.myGradleModel = gradleModel;
    }

    @Override
    public boolean canDependOn(@NotNull PsModule module) {
        if (module instanceof PsAndroidModule) {
            PsAndroidModule androidModule = (PsAndroidModule)module;
            return androidModule.isLibrary();
        }
        return true;
    }

    public boolean isLibrary() {
        return this.myGradleModel.isLibrary();
    }

    @Nullable
    public PsBuildType findBuildType(@NotNull String buildType) {
        return this.getOrCreateBuildTypeCollection().findElement(buildType, PsBuildType.class);
    }

    public void forEachBuildType(@NotNull Consumer<PsBuildType> consumer) {
        this.getOrCreateBuildTypeCollection().forEach(consumer);
    }

    @NotNull
    private PsBuildTypeCollection getOrCreateBuildTypeCollection() {
        return this.myBuildTypeCollection == null ? (this.myBuildTypeCollection = new PsBuildTypeCollection(this)) : this.myBuildTypeCollection;
    }

    public void forEachProductFlavor(@NotNull Consumer<PsProductFlavor> consumer) {
        this.getOrCreateProductFlavorCollection().forEach(consumer);
    }

    @Nullable
    public PsProductFlavor findProductFlavor(@NotNull String name) {
        return this.getOrCreateProductFlavorCollection().findElement(name, PsProductFlavor.class);
    }

    @NotNull
    private PsProductFlavorCollection getOrCreateProductFlavorCollection() {
        return this.myProductFlavorCollection == null ? (this.myProductFlavorCollection = new PsProductFlavorCollection(this)) : this.myProductFlavorCollection;
    }

    public void forEachVariant(@NotNull Consumer<PsVariant> con) {
        this.getOrCreateVariantCollection().forEach(con);
    }

    @Nullable
    public PsVariant findVariant(@NotNull String name) {
        return this.getOrCreateVariantCollection().findElement(name, PsVariant.class);
    }

    @NotNull
    private PsVariantCollection getOrCreateVariantCollection() {
        return this.myVariantCollection == null ? (this.myVariantCollection = new PsVariantCollection(this)) : this.myVariantCollection;
    }

    public void forEachDeclaredDependency(@NotNull Consumer<PsAndroidDependency> consumer) {
        this.getOrCreateDependencyCollection().forEachDeclaredDependency(consumer);
    }

    public void forEachDependency(@NotNull Consumer<PsAndroidDependency> consumer) {
        this.getOrCreateDependencyCollection().forEach(consumer);
    }

    public void forEachModuleDependency(@NotNull Consumer<PsModuleAndroidDependency> consumer) {
        this.getOrCreateDependencyCollection().forEachModuleDependency(consumer);
    }

    @Nullable
    public PsLibraryAndroidDependency findLibraryDependency(@NotNull String compactNotation) {
        return (PsLibraryAndroidDependency)this.getOrCreateDependencyCollection().findElement(compactNotation, PsLibraryAndroidDependency.class);
    }

    @Nullable
    public PsLibraryAndroidDependency findLibraryDependency(@NotNull PsArtifactDependencySpec spec) {
        return this.getOrCreateDependencyCollection().findElement(spec);
    }

    @NotNull
    private PsAndroidDependencyCollection getOrCreateDependencyCollection() {
        return this.myDependencyCollection == null ? (this.myDependencyCollection = new PsAndroidDependencyCollection(this)) : this.myDependencyCollection;
    }

    @Override
    @NotNull
    public AndroidGradleModel getGradleModel() {
        return this.myGradleModel;
    }

    @Override
    public Icon getIcon() {
        return this.myGradleModel.getAndroidProject().isLibrary() ? AndroidIcons.LibraryModule : AndroidIcons.AppModule;
    }

    @Override
    @NotNull
    public String getGradlePath() {
        String gradlePath = super.getGradlePath();
        assert (gradlePath != null);
        return gradlePath;
    }

    @Override
    @NotNull
    public Module getResolvedModel() {
        Module model = super.getResolvedModel();
        assert (model != null);
        return model;
    }

    @Override
    @NotNull
    public List<ArtifactRepository> getArtifactRepositories() {
        ArrayList repositories = Lists.newArrayList();
        this.populateRepositories(repositories);
        ArtifactRepository repository = AndroidSdkRepositories.getAndroidRepository();
        if (repository != null) {
            repositories.add(repository);
        }
        if ((repository = AndroidSdkRepositories.getGoogleRepository()) != null) {
            repositories.add(repository);
        }
        return repositories;
    }

    public void addLibraryDependency(@NotNull String library, @NotNull PsNewDependencyScopes newScopes, @NotNull List<String> scopesNames) {
        this.addLibraryDependencyToParsedModel(scopesNames, library);
        this.myDependencyCollection = null;
        PsAndroidDependencyCollection dependencyCollection = this.getOrCreateDependencyCollection();
        ArrayList targetArtifacts = Lists.newArrayList();
        this.forEachVariant(variant -> variant.forEachArtifact(artifact -> {
            if (newScopes.contains((PsAndroidArtifact)artifact)) {
                targetArtifacts.add(artifact);
            }
        }));
        assert (!targetArtifacts.isEmpty());
        PsArtifactDependencySpec spec = PsArtifactDependencySpec.create(library);
        assert (spec != null);
        PsParsedDependencies parsedDependencies = this.getParsedDependencies();
        for (PsAndroidArtifact artifact : targetArtifacts) {
            List<ArtifactDependencyModel> matchingParsedDependencies = parsedDependencies.findLibraryDependencies(spec, artifact::contains);
            for (ArtifactDependencyModel parsedDependency : matchingParsedDependencies) {
                dependencyCollection.addLibraryDependency(spec, artifact, parsedDependency);
            }
        }
        this.fireLibraryDependencyAddedEvent(spec);
        this.setModified(true);
    }
}

