/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.model.android;

import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.BaseArtifact;
import com.android.builder.model.Dependencies;
import com.android.builder.model.JavaLibrary;
import com.android.builder.model.Library;
import com.android.builder.model.MavenCoordinates;
import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.ArtifactDependencyModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.DependencyModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.ModuleDependencyModel;
import com.android.tools.idea.gradle.structure.model.PsArtifactDependencySpec;
import com.android.tools.idea.gradle.structure.model.PsDependency;
import com.android.tools.idea.gradle.structure.model.PsModelCollection;
import com.android.tools.idea.gradle.structure.model.PsModule;
import com.android.tools.idea.gradle.structure.model.PsParsedDependencies;
import com.android.tools.idea.gradle.structure.model.android.PsAndroidArtifact;
import com.android.tools.idea.gradle.structure.model.android.PsAndroidDependency;
import com.android.tools.idea.gradle.structure.model.android.PsAndroidModule;
import com.android.tools.idea.gradle.structure.model.android.PsLibraryAndroidDependency;
import com.android.tools.idea.gradle.structure.model.android.PsModuleAndroidDependency;
import com.android.tools.idea.gradle.structure.model.android.PsVariant;
import com.android.tools.idea.gradle.structure.model.pom.MavenPoms;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PsAndroidDependencyCollection
implements PsModelCollection<PsAndroidDependency> {
    @NotNull
    private final PsAndroidModule myParent;
    @NotNull
    private final Map<String, PsModuleAndroidDependency> myModuleDependenciesByGradlePath = Maps.newHashMap();
    @NotNull
    private final Map<String, PsLibraryAndroidDependency> myLibraryDependenciesBySpec = Maps.newHashMap();

    PsAndroidDependencyCollection(@NotNull PsAndroidModule parent) {
        this.myParent = parent;
        parent.forEachVariant(this::addDependencies);
    }

    private void addDependencies(@NotNull PsVariant variant) {
        variant.forEachArtifact(this::collectDependencies);
    }

    private void collectDependencies(@NotNull PsAndroidArtifact artifact) {
        BaseArtifact resolvedArtifact = artifact.getResolvedModel();
        if (resolvedArtifact == null) {
            return;
        }
        AndroidGradleModel gradleModel = artifact.getGradleModel();
        Dependencies dependencies = GradleUtil.getDependencies(resolvedArtifact, gradleModel.getModelVersion());
        for (AndroidLibrary androidLibrary : dependencies.getLibraries()) {
            String gradlePath = androidLibrary.getProject();
            if (gradlePath != null) {
                String projectVariant = androidLibrary.getProjectVariant();
                this.addModule(gradlePath, artifact, projectVariant);
                continue;
            }
            this.addLibrary((Library)androidLibrary, artifact);
        }
        for (JavaLibrary javaLibrary : dependencies.getJavaLibraries()) {
            this.addLibrary((Library)javaLibrary, artifact);
        }
    }

    private void addModule(@NotNull String gradlePath, @NotNull PsAndroidArtifact artifact, @Nullable String projectVariant) {
        PsModuleAndroidDependency dependency;
        PsParsedDependencies parsedDependencies = this.myParent.getParsedDependencies();
        ModuleDependencyModel matchingParsedDependency = parsedDependencies.findModuleDependency(gradlePath, artifact::contains);
        Module resolvedModule = null;
        PsModule module = this.myParent.getParent().findModuleByGradlePath(gradlePath);
        if (module != null) {
            resolvedModule = module.getResolvedModel();
        }
        if ((dependency = (PsModuleAndroidDependency)this.findElement(gradlePath, PsModuleAndroidDependency.class)) == null) {
            dependency = new PsModuleAndroidDependency(this.myParent, gradlePath, artifact, projectVariant, resolvedModule, matchingParsedDependency);
            this.myModuleDependenciesByGradlePath.put(gradlePath, dependency);
        }
        PsAndroidDependencyCollection.updateDependency(dependency, artifact, matchingParsedDependency);
    }

    @Nullable
    private PsAndroidDependency addLibrary(@NotNull Library library, @NotNull PsAndroidArtifact artifact) {
        PsParsedDependencies parsedDependencies = this.myParent.getParsedDependencies();
        MavenCoordinates coordinates = library.getResolvedCoordinates();
        if (coordinates != null) {
            PsArtifactDependencySpec spec = PsArtifactDependencySpec.create(coordinates);
            ArtifactDependencyModel matchingParsedDependency = parsedDependencies.findLibraryDependency(coordinates, artifact::contains);
            if (matchingParsedDependency != null) {
                String parsedVersionValue = matchingParsedDependency.version().value();
                if (parsedVersionValue != null) {
                    GradleVersion parsedVersion = GradleVersion.tryParse((String)parsedVersionValue);
                    GradleVersion versionFromGradle = GradleVersion.parse((String)coordinates.getVersion());
                    if (parsedVersion != null && PsAndroidDependencyCollection.compare(parsedVersion, versionFromGradle) == 0) {
                        return this.addLibrary(library, spec, artifact, matchingParsedDependency);
                    }
                    PsLibraryAndroidDependency potentialDuplicate = null;
                    for (PsLibraryAndroidDependency dependency : this.myLibraryDependenciesBySpec.values()) {
                        if (!dependency.getParsedModels().contains((Object)matchingParsedDependency)) continue;
                        potentialDuplicate = dependency;
                        break;
                    }
                    if (potentialDuplicate != null) {
                        // empty if block
                    }
                    this.addLibrary(library, spec, artifact, matchingParsedDependency);
                    return this.addLibrary(library, spec, artifact, null);
                }
            } else {
                return this.addLibrary(library, spec, artifact, null);
            }
        }
        return null;
    }

    @Nullable
    private PsAndroidDependency addLibrary(@NotNull Library library, @NotNull PsArtifactDependencySpec resolvedSpec, @NotNull PsAndroidArtifact artifact, @Nullable ArtifactDependencyModel parsedModel) {
        if (library instanceof AndroidLibrary) {
            AndroidLibrary androidLibrary = (AndroidLibrary)library;
            return this.addAndroidLibrary(androidLibrary, resolvedSpec, artifact, parsedModel);
        }
        if (library instanceof JavaLibrary) {
            JavaLibrary javaLibrary = (JavaLibrary)library;
            return this.addJavaLibrary(javaLibrary, resolvedSpec, artifact, parsedModel);
        }
        return null;
    }

    @NotNull
    private PsAndroidDependency addAndroidLibrary(@NotNull AndroidLibrary androidLibrary, @NotNull PsArtifactDependencySpec resolvedSpec, @NotNull PsAndroidArtifact artifact, @Nullable ArtifactDependencyModel parsedModel) {
        PsAndroidDependency dependency = this.getOrCreateDependency(resolvedSpec, (Library)androidLibrary, artifact, parsedModel);
        for (Library library : androidLibrary.getLibraryDependencies()) {
            this.addTransitive(library, artifact, dependency);
        }
        AndroidGradleModel gradleModel = artifact.getGradleModel();
        if (gradleModel.getFeatures().isDependencyGraphSupported()) {
            for (Library library : androidLibrary.getJavaDependencies()) {
                this.addTransitive(library, artifact, dependency);
            }
        }
        PsAndroidDependencyCollection.updateDependency(dependency, artifact, parsedModel);
        return dependency;
    }

    @NotNull
    private PsAndroidDependency addJavaLibrary(@NotNull JavaLibrary javaLibrary, @NotNull PsArtifactDependencySpec resolvedSpec, @NotNull PsAndroidArtifact artifact, @Nullable ArtifactDependencyModel parsedModel) {
        PsAndroidDependency dependency = this.getOrCreateDependency(resolvedSpec, (Library)javaLibrary, artifact, parsedModel);
        for (Library library : javaLibrary.getDependencies()) {
            this.addTransitive(library, artifact, dependency);
        }
        PsAndroidDependencyCollection.updateDependency(dependency, artifact, parsedModel);
        return dependency;
    }

    private void addTransitive(@NotNull Library transitiveDependency, @NotNull PsAndroidArtifact artifact, @NotNull PsAndroidDependency dependency) {
        PsAndroidDependency transitive = this.addLibrary(transitiveDependency, artifact);
        if (transitive != null && dependency instanceof PsLibraryAndroidDependency) {
            PsLibraryAndroidDependency libraryDependency = (PsLibraryAndroidDependency)dependency;
            libraryDependency.addTransitiveDependency(transitive.toText(PsDependency.TextType.PLAIN_TEXT));
        }
    }

    @VisibleForTesting
    static int compare(@NotNull GradleVersion parsedVersion, @NotNull GradleVersion versionFromGradle) {
        int result = versionFromGradle.compareTo(parsedVersion);
        if (result == 0) {
            return result;
        }
        if (result < 0) {
            if (parsedVersion.getMajorSegment().acceptsGreaterValue()) {
                return 0;
            }
            if (parsedVersion.getMinorSegment() != null && parsedVersion.getMinorSegment().acceptsGreaterValue()) {
                return parsedVersion.getMajor() - versionFromGradle.getMajor();
            }
            if (parsedVersion.getMicroSegment() != null && parsedVersion.getMicroSegment().acceptsGreaterValue()) {
                result = parsedVersion.getMajor() - versionFromGradle.getMajor();
                if (result != 0) {
                    return result;
                }
                return parsedVersion.getMinor() - versionFromGradle.getMinor();
            }
        }
        return result;
    }

    @NotNull
    private PsAndroidDependency getOrCreateDependency(@NotNull PsArtifactDependencySpec resolvedSpec, @NotNull Library library, @NotNull PsAndroidArtifact artifact, @Nullable ArtifactDependencyModel parsedModel) {
        String compactNotation = resolvedSpec.toString();
        PsLibraryAndroidDependency dependency = this.myLibraryDependenciesBySpec.get(compactNotation);
        if (dependency == null) {
            dependency = new PsLibraryAndroidDependency(this.myParent, resolvedSpec, artifact, library, parsedModel);
            this.myLibraryDependenciesBySpec.put(compactNotation, dependency);
            File libraryPath = null;
            if (library instanceof AndroidLibrary) {
                libraryPath = ((AndroidLibrary)library).getBundle();
            } else if (library instanceof JavaLibrary) {
                libraryPath = ((JavaLibrary)library).getJarFile();
            }
            if (!artifact.getGradleModel().getFeatures().isDependencyGraphSupported()) {
                List<PsArtifactDependencySpec> pomDependencies = Collections.emptyList();
                if (libraryPath != null) {
                    pomDependencies = MavenPoms.findDependenciesInPomFile(libraryPath);
                }
                dependency.setDependenciesFromPomFile(pomDependencies);
            }
        } else if (parsedModel != null) {
            dependency.addParsedModel(parsedModel);
        }
        return dependency;
    }

    @Nullable
    PsLibraryAndroidDependency findElement(PsArtifactDependencySpec spec) {
        PsLibraryAndroidDependency dependency = (PsLibraryAndroidDependency)this.findElement(spec.toString(), PsLibraryAndroidDependency.class);
        if (dependency != null) {
            return dependency;
        }
        if (StringUtil.isEmpty((String)spec.version)) {
            ArrayList found = Lists.newArrayList();
            for (String specText : this.myLibraryDependenciesBySpec.keySet()) {
                PsArtifactDependencySpec storedSpec = PsArtifactDependencySpec.create(specText);
                if (storedSpec == null || !Objects.equals(storedSpec.group, spec.group) || !Objects.equals(storedSpec.name, spec.name)) continue;
                found.add(specText);
            }
            if (found.size() == 1) {
                return this.myLibraryDependenciesBySpec.get(found.get(0));
            }
        }
        return null;
    }

    @Override
    @Nullable
    public <S extends PsAndroidDependency> S findElement(@NotNull String name, @Nullable Class<S> type) {
        if (PsModuleAndroidDependency.class.equals(type)) {
            return (S)((PsAndroidDependency)type.cast(this.myModuleDependenciesByGradlePath.get(name)));
        }
        if (PsLibraryAndroidDependency.class.equals(type)) {
            return (S)((PsAndroidDependency)type.cast(this.myLibraryDependenciesBySpec.get(name)));
        }
        return null;
    }

    @Override
    public void forEach(@NotNull Consumer<PsAndroidDependency> consumer) {
        PsAndroidDependencyCollection.forEachDependency(this.myLibraryDependenciesBySpec, consumer);
        PsAndroidDependencyCollection.forEachDependency(this.myModuleDependenciesByGradlePath, consumer);
    }

    private static void forEachDependency(@NotNull Map<String, ? extends PsAndroidDependency> dependenciesBySpec, @NotNull Consumer<PsAndroidDependency> consumer) {
        dependenciesBySpec.values().forEach(consumer);
    }

    void forEachDeclaredDependency(@NotNull Consumer<PsAndroidDependency> consumer) {
        PsAndroidDependencyCollection.forEachDeclaredDependency(this.myLibraryDependenciesBySpec, consumer);
        PsAndroidDependencyCollection.forEachDeclaredDependency(this.myModuleDependenciesByGradlePath, consumer);
    }

    private static void forEachDeclaredDependency(@NotNull Map<String, ? extends PsAndroidDependency> dependenciesBySpec, @NotNull Consumer<PsAndroidDependency> consumer) {
        dependenciesBySpec.values().stream().filter(PsDependency::isDeclared).forEach(consumer);
    }

    void forEachModuleDependency(@NotNull Consumer<PsModuleAndroidDependency> consumer) {
        this.myModuleDependenciesByGradlePath.values().forEach(consumer);
    }

    void addLibraryDependency(@NotNull PsArtifactDependencySpec spec, @NotNull PsAndroidArtifact artifact, @Nullable ArtifactDependencyModel parsedModel) {
        PsLibraryAndroidDependency dependency = this.myLibraryDependenciesBySpec.get(spec.toString());
        if (dependency == null) {
            dependency = new PsLibraryAndroidDependency(this.myParent, spec, artifact, null, parsedModel);
            this.myLibraryDependenciesBySpec.put(spec.toString(), dependency);
        } else {
            PsAndroidDependencyCollection.updateDependency(dependency, artifact, parsedModel);
        }
    }

    private static void updateDependency(@NotNull PsAndroidDependency dependency, @NotNull PsAndroidArtifact artifact, @Nullable DependencyModel parsedModel) {
        if (parsedModel != null) {
            dependency.addParsedModel(parsedModel);
        }
        dependency.addContainer(artifact);
    }
}

