/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.model.android;

import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.DependencyModel;
import com.android.tools.idea.gradle.structure.model.PsDependency;
import com.android.tools.idea.gradle.structure.model.android.PsAndroidArtifact;
import com.android.tools.idea.gradle.structure.model.android.PsAndroidModel;
import com.android.tools.idea.gradle.structure.model.android.PsAndroidModule;
import com.android.tools.idea.gradle.structure.model.android.PsDependencyContainer;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PsAndroidDependency
extends PsDependency
implements PsAndroidModel {
    @NotNull
    private final Set<PsDependencyContainer> myContainers = Sets.newHashSet();

    PsAndroidDependency(@NotNull PsAndroidModule parent, @NotNull PsAndroidArtifact container, @Nullable DependencyModel parsedModel) {
        super(parent, parsedModel);
        this.addContainer(container);
    }

    @Override
    @NotNull
    public AndroidGradleModel getGradleModel() {
        return this.getParent().getGradleModel();
    }

    @Override
    @NotNull
    public PsAndroidModule getParent() {
        return (PsAndroidModule)super.getParent();
    }

    void addContainer(@NotNull PsAndroidArtifact artifact) {
        this.myContainers.add(new PsDependencyContainer(artifact));
    }

    @NotNull
    public Collection<String> getVariants() {
        return this.myContainers.stream().map(PsDependencyContainer::getVariant).collect(Collectors.toSet());
    }

    @NotNull
    public Collection<PsDependencyContainer> getContainers() {
        return this.myContainers;
    }

    public boolean isIn(@NotNull String artifactName, @Nullable String variantName) {
        for (PsDependencyContainer container : this.myContainers) {
            if (!artifactName.equals(container.getArtifact())) continue;
            if (variantName == null) {
                return true;
            }
            if (!variantName.equals(container.getVariant())) continue;
            return true;
        }
        return false;
    }
}

