/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.model;

import com.android.tools.idea.gradle.dsl.model.dependencies.DependencyModel;
import com.android.tools.idea.gradle.structure.model.PsBaseDependency;
import com.android.tools.idea.gradle.structure.model.PsChildModel;
import com.android.tools.idea.gradle.structure.model.PsModule;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PsDependency
extends PsChildModel
implements PsBaseDependency {
    @NotNull
    private final Set<DependencyModel> myParsedModels = Sets.newHashSet();

    protected PsDependency(@NotNull PsModule parent, @Nullable DependencyModel parsedModel) {
        super(parent);
        if (parsedModel != null) {
            this.myParsedModels.add(parsedModel);
        }
    }

    @Override
    @NotNull
    public String getJoinedConfigurationNames() {
        List<String> configurationNames = this.getConfigurationNames();
        int count = configurationNames.size();
        if (count == 1) {
            return configurationNames.get(0);
        }
        if (count > 1) {
            return Joiner.on((String)", ").join(configurationNames);
        }
        return "";
    }

    @NotNull
    public List<String> getConfigurationNames() {
        if (this.myParsedModels.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList names = Lists.newArrayList((Iterable)this.myParsedModels.stream().map(DependencyModel::configurationName).collect(Collectors.toSet()));
        Collections.sort(names);
        return names;
    }

    @Override
    public boolean isDeclared() {
        return !this.myParsedModels.isEmpty();
    }

    public void addParsedModel(@NotNull DependencyModel parsedModel) {
        this.myParsedModels.add(parsedModel);
    }

    @NotNull
    public ImmutableCollection<DependencyModel> getParsedModels() {
        return this.myParsedModels.isEmpty() ? ImmutableSet.of() : ImmutableSet.copyOf(this.myParsedModels);
    }

    public static enum TextType {
        PLAIN_TEXT,
        FOR_NAVIGATION;

    }
}

