/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.dependencies.java;

import com.android.tools.idea.gradle.structure.configurables.ui.PsCheckBoxList;
import com.android.tools.idea.gradle.structure.configurables.ui.ToolWindowHeader;
import com.android.tools.idea.gradle.structure.configurables.ui.ToolWindowPanel;
import com.android.tools.idea.gradle.structure.dependencies.AbstractDependencyScopesPanel;
import com.android.tools.idea.gradle.structure.model.java.PsJavaModule;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ListSpeedSearch;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.UIUtil;
import icons.AndroidIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import org.jdesktop.swingx.JXLabel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaDependencyScopesPanel
extends AbstractDependencyScopesPanel {
    @NotNull
    private final ToolWindowPanel myToolWindowPanel;
    @NotNull
    private final PsCheckBoxList<String> myConfigurationsList;
    private JPanel myContentsPanel;
    private JPanel myMainPanel;
    private JXLabel myScopesLabel;

    public JavaDependencyScopesPanel(@NotNull PsJavaModule module) {
        this.$$$setupUI$$$();
        this.myScopesLabel.setBorder((Border)BorderFactory.createCompoundBorder(UIUtil.getTextFieldBorder(), IdeBorderFactory.createEmptyBorder((int)2)));
        this.myScopesLabel.setBackground(UIUtil.getTextFieldBackground());
        this.myScopesLabel.setText(" ");
        ArrayList configurations = Lists.newArrayList(module.getGradleModel().getConfigurations());
        Collections.sort(configurations, ConfigurationComparator.INSTANCE);
        String selected = null;
        if (!configurations.isEmpty()) {
            selected = (String)configurations.get(0);
        }
        this.myConfigurationsList = new PsCheckBoxList(configurations);
        if (selected != null) {
            this.myConfigurationsList.setItemSelected(selected, true);
            this.updateLabel(this.getSelectedScopeNames());
        }
        this.myConfigurationsList.setSelectionChangeListener(this::updateLabel);
        new ListSpeedSearch(this.myConfigurationsList);
        this.myToolWindowPanel = new ToolWindowPanel("Configurations", AndroidIcons.Android, null){};
        ToolWindowHeader header = this.myToolWindowPanel.getHeader();
        header.setPreferredFocusedComponent((JComponent)((Object)this.myConfigurationsList));
        header.setAdditionalActions(this.myConfigurationsList.createSelectAllAction(), this.myConfigurationsList.createUnselectAllAction());
        header.setBorder(IdeBorderFactory.createBorder((int)7));
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane(this.myConfigurationsList);
        scrollPane.setBorder(IdeBorderFactory.createBorder((int)13));
        this.myToolWindowPanel.add((Component)scrollPane, "Center");
        this.myContentsPanel.add((Component)this.myToolWindowPanel, "Center");
        this.setUpContents(this.myMainPanel, JavaDependencyScopesPanel.getInstructions());
    }

    private void updateLabel(@NotNull List<String> newSelection) {
        String selectedScopes = Joiner.on((String)", ").skipNulls().join(this.getSelectedScopeNames());
        if (StringUtil.isEmpty((String)selectedScopes)) {
            selectedScopes = " ";
        }
        this.myScopesLabel.setText(selectedScopes);
    }

    @NotNull
    private static String getInstructions() {
        return "Assign a scope to the new dependency by selecting the configurations below.<br/><a href='https://docs.gradle.org/current/userguide/artifact_dependencies_tutorial.html'>Open Documentation</a>";
    }

    @Override
    @Nullable
    public ValidationInfo validateInput() {
        if (this.getSelectedScopeNames().isEmpty()) {
            return new ValidationInfo("Please select at least one configuration", this.myConfigurationsList);
        }
        return null;
    }

    @Override
    @NotNull
    public List<String> getSelectedScopeNames() {
        ArrayList scopes = Lists.newArrayList(this.myConfigurationsList.getSelectedItems());
        Collections.sort(scopes, ConfigurationComparator.INSTANCE);
        return scopes;
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.myToolWindowPanel);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JXLabel jXLabel;
        JPanel jPanel;
        JPanel jPanel2;
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myContentsPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(0, 0, 1, 2, 0, 3, 7, 7, null, null, null));
        this.myScopesLabel = jXLabel = new JXLabel();
        jXLabel.setLineWrap(true);
        jPanel2.add((Component)jXLabel, new GridConstraints(1, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Scope:");
        jPanel2.add((Component)jBLabel, new GridConstraints(1, 0, 1, 1, 0, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private static class ConfigurationComparator
    implements Comparator<String> {
        static final ConfigurationComparator INSTANCE = new ConfigurationComparator();

        private ConfigurationComparator() {
        }

        @Override
        public int compare(String s1, String s2) {
            if ("compile".equals(s1)) {
                return -1;
            }
            if ("compile".endsWith(s2)) {
                return 1;
            }
            return s1.compareTo(s2);
        }
    }
}

