/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.daemon;

import com.android.tools.idea.gradle.structure.configurables.PsContext;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.Alarm;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PsDaemon
implements Disposable {
    @NotNull
    private final PsContext myContext;
    @NotNull
    private final AtomicBoolean myStopped = new AtomicBoolean(false);

    protected PsDaemon(@NotNull PsContext context) {
        this.myContext = context;
        Disposer.register((Disposable)context, (Disposable)this);
    }

    @NotNull
    protected final MergingUpdateQueue createQueue(@NotNull String name, @Nullable JComponent modalityStateComponent) {
        return new MergingUpdateQueue(name, 300, false, modalityStateComponent, (Disposable)this, null, Alarm.ThreadToUse.POOLED_THREAD);
    }

    public void reset() {
        MergingUpdateQueue mainQueue = this.getMainQueue();
        PsDaemon.reset(mainQueue, this.getResultsUpdaterQueue());
        mainQueue.queue(new Update("reset"){

            public void run() {
                PsDaemon.this.myStopped.set(false);
            }
        });
    }

    private static void reset(MergingUpdateQueue ... queues) {
        for (MergingUpdateQueue queue : queues) {
            queue.activate();
        }
    }

    public void stop() {
        this.myStopped.set(true);
        PsDaemon.stop(this.getMainQueue(), this.getResultsUpdaterQueue());
    }

    private static void stop(MergingUpdateQueue ... queues) {
        for (MergingUpdateQueue queue : queues) {
            queue.cancelAllUpdates();
            queue.deactivate();
        }
    }

    @NotNull
    protected abstract MergingUpdateQueue getMainQueue();

    @NotNull
    protected abstract MergingUpdateQueue getResultsUpdaterQueue();

    protected boolean isStopped() {
        return this.myStopped.get();
    }

    @NotNull
    protected PsContext getContext() {
        return this.myContext;
    }

    public abstract boolean isRunning();

    public void dispose() {
        this.stop();
    }
}

