/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables.ui.treeview;

import com.android.tools.idea.gradle.structure.configurables.ui.treeview.AbstractPsNode;
import com.android.tools.idea.gradle.structure.model.PsModel;
import com.google.common.collect.Lists;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ui.SimpleTextAttributes;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractPsModelNode<T extends PsModel>
extends AbstractPsNode {
    @NotNull
    private final List<T> myModels;

    @SafeVarargs
    protected AbstractPsModelNode(@NotNull AbstractPsNode parent, T ... models) {
        super(parent);
        this.myModels = Lists.newArrayList((Object[])models);
        this.updateNameAndIcon();
    }

    @SafeVarargs
    protected AbstractPsModelNode(T ... models) {
        this.myModels = Lists.newArrayList((Object[])models);
        this.updateNameAndIcon();
    }

    protected AbstractPsModelNode(@NotNull AbstractPsNode parent, @NotNull List<T> models) {
        super(parent);
        this.myModels = models;
        this.updateNameAndIcon();
    }

    protected AbstractPsModelNode(@NotNull List<T> models) {
        this.myModels = models;
        this.updateNameAndIcon();
    }

    protected void updateNameAndIcon() {
        int modelCount = this.myModels.size();
        if (modelCount != 0) {
            PsModel first = (PsModel)this.myModels.get(0);
            if (modelCount == 1) {
                this.myName = this.nameOf(first);
            } else {
                StringBuilder buffer = new StringBuilder();
                for (int i = 0; i < modelCount; ++i) {
                    PsModel model = (PsModel)this.myModels.get(i);
                    buffer.append(this.nameOf(model));
                    if (i >= modelCount - 1) continue;
                    buffer.append(", ");
                }
                this.myName = buffer.toString();
            }
            this.setIcon(first.getIcon());
        }
    }

    @NotNull
    protected String nameOf(T model) {
        return ((PsModel)model).getName();
    }

    @NotNull
    public List<T> getModels() {
        return this.myModels;
    }

    @NotNull
    public T getFirstModel() {
        assert (!this.myModels.isEmpty());
        return (T)((PsModel)this.myModels.get(0));
    }

    public boolean matches(@NotNull PsModel model) {
        for (PsModel m : this.myModels) {
            if (!m.equals(model)) continue;
            return true;
        }
        return false;
    }

    protected void doUpdate() {
        PresentationData presentation = this.getTemplatePresentation();
        presentation.clearText();
        presentation.addText(this.myName, SimpleTextAttributes.REGULAR_ATTRIBUTES);
    }
}

