/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables.android.dependencies.treeview.graph;

import com.android.tools.idea.gradle.structure.configurables.android.dependencies.treeview.AbstractDependencyNode;
import com.android.tools.idea.gradle.structure.configurables.android.dependencies.treeview.DependencyNodeComparator;
import com.android.tools.idea.gradle.structure.configurables.android.dependencies.treeview.LibraryDependencyNode;
import com.android.tools.idea.gradle.structure.configurables.android.dependencies.treeview.ModuleDependencyNode;
import com.android.tools.idea.gradle.structure.configurables.ui.treeview.AbstractPsModelNode;
import com.android.tools.idea.gradle.structure.configurables.ui.treeview.AbstractPsNode;
import com.android.tools.idea.gradle.structure.configurables.ui.treeview.AbstractPsResettableNode;
import com.android.tools.idea.gradle.structure.model.PsArtifactDependencySpec;
import com.android.tools.idea.gradle.structure.model.PsModel;
import com.android.tools.idea.gradle.structure.model.PsModule;
import com.android.tools.idea.gradle.structure.model.android.PsAndroidDependency;
import com.android.tools.idea.gradle.structure.model.android.PsAndroidModule;
import com.android.tools.idea.gradle.structure.model.android.PsLibraryAndroidDependency;
import com.android.tools.idea.gradle.structure.model.android.PsModuleAndroidDependency;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class DependenciesTreeRootNode<T extends PsModel>
extends AbstractPsResettableNode<T> {
    @NotNull
    private final DependencyCollectorFunction<T> myDependencyCollectorFunction;

    public DependenciesTreeRootNode(@NotNull T model, @NotNull DependencyCollectorFunction<T> dependencyCollectorFunction) {
        super(model);
        this.myDependencyCollectorFunction = dependencyCollectorFunction;
    }

    @Override
    @NotNull
    protected List<? extends AbstractPsModelNode> createChildren() {
        AbstractDependencyNode child;
        Object model = this.getFirstModel();
        DependencyCollector collector = (DependencyCollector)this.myDependencyCollectorFunction.apply(model);
        ArrayList children = Lists.newArrayList();
        for (Map.Entry<LibraryDependencySpecs, List<PsLibraryAndroidDependency>> entry : collector.libraryDependenciesBySpec.entrySet()) {
            child = new LibraryDependencyNode((AbstractPsNode)this, entry.getValue());
            children.add(child);
        }
        for (Map.Entry<Object, List<PsAndroidDependency>> entry : collector.moduleDependenciesByGradlePath.entrySet()) {
            child = new ModuleDependencyNode((AbstractPsNode)this, (List<PsModuleAndroidDependency>)entry.getValue());
            children.add(child);
        }
        Collections.sort(children, DependencyNodeComparator.INSTANCE);
        return children;
    }

    private static class LibraryDependencySpecs {
        @NotNull
        final PsArtifactDependencySpec declaredSpec;
        @NotNull
        final PsArtifactDependencySpec resolvedSpec;

        LibraryDependencySpecs(@NotNull PsLibraryAndroidDependency dependency) {
            PsArtifactDependencySpec declaredSpec = dependency.getDeclaredSpec();
            assert (declaredSpec != null);
            this.declaredSpec = declaredSpec;
            this.resolvedSpec = dependency.getResolvedSpec();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LibraryDependencySpecs that = (LibraryDependencySpecs)o;
            return Objects.equal((Object)this.declaredSpec, (Object)that.declaredSpec) && Objects.equal((Object)this.resolvedSpec, (Object)that.resolvedSpec);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.declaredSpec, this.resolvedSpec});
        }
    }

    public static class DependencyCollector {
        @NotNull
        final Map<LibraryDependencySpecs, List<PsLibraryAndroidDependency>> libraryDependenciesBySpec = Maps.newHashMap();
        @NotNull
        final Map<String, List<PsModuleAndroidDependency>> moduleDependenciesByGradlePath = Maps.newHashMap();

        void add(@NotNull PsAndroidDependency dependency) {
            if (dependency instanceof PsLibraryAndroidDependency) {
                this.add((PsLibraryAndroidDependency)dependency);
            } else if (dependency instanceof PsModuleAndroidDependency) {
                this.add((PsModuleAndroidDependency)dependency);
            }
        }

        private void add(@NotNull PsLibraryAndroidDependency dependency) {
            LibraryDependencySpecs specs = new LibraryDependencySpecs(dependency);
            ArrayList dependencies = this.libraryDependenciesBySpec.get(specs);
            if (dependencies == null) {
                dependencies = Lists.newArrayList();
                this.libraryDependenciesBySpec.put(specs, dependencies);
            }
            dependencies.add(dependency);
        }

        private void add(@NotNull PsModuleAndroidDependency dependency) {
            String key = dependency.getGradlePath();
            ArrayList dependencies = this.moduleDependenciesByGradlePath.get(key);
            if (dependencies == null) {
                dependencies = Lists.newArrayList();
                this.moduleDependenciesByGradlePath.put(key, dependencies);
            }
            dependencies.add(dependency);
        }
    }

    public static abstract class DependencyCollectorFunction<T extends PsModel>
    implements Function<T, DependencyCollector> {
        protected void collectDeclaredDependencies(@NotNull PsModule module, @NotNull DependencyCollector collector) {
            if (module instanceof PsAndroidModule) {
                PsAndroidModule androidModule = (PsAndroidModule)module;
                androidModule.forEachDeclaredDependency(collector::add);
            }
        }
    }
}

