/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables.android.dependencies.project.treeview;

import com.android.tools.idea.gradle.structure.configurables.android.dependencies.project.treeview.Configuration;
import com.android.tools.idea.gradle.structure.configurables.android.dependencies.project.treeview.TargetAndroidModuleNode;
import com.android.tools.idea.gradle.structure.configurables.android.dependencies.project.treeview.TargetConfigurationNode;
import com.android.tools.idea.gradle.structure.configurables.android.dependencies.treeview.AbstractDependencyNode;
import com.android.tools.idea.gradle.structure.configurables.ui.treeview.AbstractBaseTreeStructure;
import com.android.tools.idea.gradle.structure.configurables.ui.treeview.AbstractPsNode;
import com.android.tools.idea.gradle.structure.configurables.ui.treeview.PsRootNode;
import com.android.tools.idea.gradle.structure.configurables.ui.treeview.SimpleNodeComparator;
import com.android.tools.idea.gradle.structure.model.PsArtifactDependencySpec;
import com.android.tools.idea.gradle.structure.model.PsDependency;
import com.android.tools.idea.gradle.structure.model.android.PsAndroidArtifact;
import com.android.tools.idea.gradle.structure.model.android.PsAndroidDependency;
import com.android.tools.idea.gradle.structure.model.android.PsAndroidModule;
import com.android.tools.idea.gradle.structure.model.android.PsDependencyContainer;
import com.android.tools.idea.gradle.structure.model.android.PsLibraryAndroidDependency;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.treeStructure.SimpleNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

class TargetModulesTreeStructure
extends AbstractBaseTreeStructure {
    @NotNull
    private final PsRootNode myRootNode = new PsRootNode();

    TargetModulesTreeStructure() {
    }

    @NotNull
    public Object getRootElement() {
        return this.myRootNode;
    }

    void displayTargetModules(@NotNull List<AbstractDependencyNode<? extends PsAndroidDependency>> dependencyNodes) {
        HashMap modules = Maps.newHashMap();
        HashMultimap configurationNamesByModule = HashMultimap.create();
        dependencyNodes.forEach(arg_0 -> TargetModulesTreeStructure.lambda$displayTargetModules$126(modules, (Multimap)configurationNamesByModule, arg_0));
        ArrayList children = Lists.newArrayList();
        for (Pair moduleAndVersion : modules.values()) {
            PsAndroidModule module = (PsAndroidModule)moduleAndVersion.getFirst();
            TargetAndroidModuleNode moduleNode = new TargetAndroidModuleNode((AbstractPsNode)this.myRootNode, module, (String)moduleAndVersion.getSecond());
            ArrayList configurations = Lists.newArrayList((Iterable)configurationNamesByModule.get((Object)module.getName()));
            Collections.sort(configurations);
            ArrayList nodes = Lists.newArrayList();
            configurations.forEach(configuration -> nodes.add(new TargetConfigurationNode((Configuration)configuration)));
            moduleNode.setChildren(nodes);
            children.add(moduleNode);
        }
        Collections.sort(children, new SimpleNodeComparator());
        this.myRootNode.setChildren(children);
    }

    @NotNull
    private static List<AbstractDependencyNode<? extends PsAndroidDependency>> getDeclaredDependencyNodeHierarchy(AbstractDependencyNode<?> node) {
        ArrayList nodes = Lists.newArrayList();
        if (node.isDeclared()) {
            nodes.add(node);
        }
        SimpleNode current = node;
        while (true) {
            SimpleNode parent;
            if ((parent = current.getParent()) instanceof AbstractDependencyNode && ((AbstractDependencyNode)parent).isDeclared()) {
                nodes.add((AbstractDependencyNode)parent);
            } else if (parent == null) break;
            current = parent;
        }
        return nodes;
    }

    @NotNull
    private static List<PsAndroidDependency> getDeclaredDependencies(AbstractDependencyNode<? extends PsAndroidDependency> node) {
        return node.getModels().stream().filter(PsDependency::isDeclared).collect(Collectors.toList());
    }

    private static /* synthetic */ void lambda$displayTargetModules$126(Map map, Multimap multimap, AbstractDependencyNode node) {
        List<AbstractDependencyNode<? extends PsAndroidDependency>> declaredDependencyNodes = TargetModulesTreeStructure.getDeclaredDependencyNodeHierarchy(node);
        HashMap versionByModule = Maps.newHashMap();
        for (PsAndroidDependency dependency : node.getModels()) {
            if (!(dependency instanceof PsLibraryAndroidDependency)) continue;
            PsLibraryAndroidDependency libraryDependency = (PsLibraryAndroidDependency)dependency;
            PsArtifactDependencySpec spec = libraryDependency.getDeclaredSpec();
            if (spec == null) {
                spec = libraryDependency.getResolvedSpec();
            }
            PsAndroidModule module = dependency.getParent();
            versionByModule.put(module.getName(), spec.version);
        }
        AbstractDependencyNode<? extends PsAndroidDependency> topParentNode = declaredDependencyNodes.get(declaredDependencyNodes.size() - 1);
        for (PsAndroidDependency dependency : topParentNode.getModels()) {
            PsAndroidModule module = dependency.getParent();
            String moduleName = module.getName();
            Pair existing = (Pair)map.get(moduleName);
            if (existing != null) continue;
            map.put(moduleName, Pair.create((Object)module, versionByModule.get(moduleName)));
        }
        declaredDependencyNodes.forEach(declaredDependencyNode -> {
            List<PsAndroidDependency> declaredDependencies = TargetModulesTreeStructure.getDeclaredDependencies(declaredDependencyNode);
            declaredDependencies.forEach(declaredDependency -> {
                List<String> configurationNames = declaredDependency.getConfigurationNames();
                assert (!configurationNames.isEmpty());
                PsAndroidModule module = declaredDependency.getParent();
                String moduleName = module.getName();
                for (PsDependencyContainer container : declaredDependency.getContainers()) {
                    PsAndroidArtifact artifact = container.findArtifact(module, false);
                    for (String configurationName : configurationNames) {
                        if (artifact == null || !artifact.containsConfigurationName(configurationName)) continue;
                        boolean transitive = declaredDependencyNode != node;
                        Collection configurations = multimap.get((Object)moduleName);
                        boolean found = false;
                        for (Configuration configuration : configurations) {
                            if (!configuration.getName().equals(configurationName)) continue;
                            configuration.addType(transitive);
                            found = true;
                            break;
                        }
                        if (found) continue;
                        Icon icon = artifact.getIcon();
                        multimap.put((Object)moduleName, (Object)new Configuration(configurationName, icon, transitive));
                    }
                }
            });
        });
    }
}

