/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.service.sync.change;

import com.android.tools.idea.gradle.service.sync.change.DefaultProjectStructureEntityDescriptionBuilder;
import com.android.tools.idea.gradle.service.sync.change.ProjectStructureChange;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractProjectStructureChange<T>
implements ProjectStructureChange<T> {
    @NotNull
    private final DataNode<T> myData;
    @NotNull
    private final String myDataDescription;

    protected AbstractProjectStructureChange(@NotNull DataNode<T> data) throws IllegalArgumentException {
        this(data, DefaultProjectStructureEntityDescriptionBuilder.build(data));
    }

    protected AbstractProjectStructureChange(@NotNull DataNode<T> data, @NotNull String dataDescription) {
        this.myData = data;
        this.myDataDescription = dataDescription;
    }

    @Override
    @NotNull
    public Key<T> getKey() {
        return this.myData.getKey();
    }

    @NotNull
    public DataNode<T> getData() {
        return this.myData;
    }

    @NotNull
    protected String getDataDescription() {
        return this.myDataDescription;
    }

    public int hashCode() {
        int result = this.myData.getKey().hashCode();
        result = 31 * result + this.myData.getData().hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractProjectStructureChange that = (AbstractProjectStructureChange)o;
        return this.myData.getKey().equals((Object)that.myData.getKey()) && this.myData.getData().equals(that.myData.getData());
    }

    public String toString() {
        return this.getDescription();
    }
}

