/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.service.notification.errors;

import com.android.tools.idea.gradle.service.notification.errors.AbstractSyncErrorHandler;
import com.android.tools.idea.gradle.service.notification.hyperlink.CreateGradleWrapperHyperlink;
import com.android.tools.idea.gradle.service.notification.hyperlink.FixGradleVersionInWrapperHyperlink;
import com.android.tools.idea.gradle.service.notification.hyperlink.NotificationHyperlink;
import com.android.tools.idea.gradle.service.notification.hyperlink.OpenGradleSettingsHyperlink;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.google.common.collect.Lists;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;

public class UnsupportedGradleVersionErrorHandler
extends AbstractSyncErrorHandler {
    private static final Pattern UNSUPPORTED_GRADLE_VERSION_PATTERN = Pattern.compile("Gradle version (.*) is required.*?");

    @Override
    public boolean handleError(@NotNull List<String> message, @NotNull ExternalSystemException error, @NotNull NotificationData notification, @NotNull Project project) {
        String firstLine = message.get(0);
        List<NotificationHyperlink> hyperlinks = null;
        String supportedGradleVersion = UnsupportedGradleVersionErrorHandler.getSupportedGradleVersion(firstLine);
        if (StringUtil.isNotEmpty((String)supportedGradleVersion)) {
            hyperlinks = UnsupportedGradleVersionErrorHandler.getQuickFixHyperlinks(project, supportedGradleVersion);
        } else {
            String lastLine = message.get(message.size() - 1);
            if ("Please fix the project's Gradle settings.".equals(lastLine) || lastLine.contains("Please point to a supported Gradle version in the project's Gradle settings or in the project's Gradle wrapper (if applicable.)")) {
                hyperlinks = UnsupportedGradleVersionErrorHandler.getQuickFixHyperlinks(project, null);
            }
        }
        if (hyperlinks != null) {
            UnsupportedGradleVersionErrorHandler.updateNotification(notification, project, error.getMessage(), hyperlinks);
            return true;
        }
        return false;
    }

    @Nullable
    public static String getSupportedGradleVersion(@NotNull String message) {
        String version;
        Matcher matcher = UNSUPPORTED_GRADLE_VERSION_PATTERN.matcher(message);
        if (matcher.matches() && StringUtil.isNotEmpty((String)(version = matcher.group(1)))) {
            return version;
        }
        return null;
    }

    @NotNull
    public static List<NotificationHyperlink> getQuickFixHyperlinks(@NotNull Project project, @Nullable String gradleVersion) {
        ArrayList hyperlinks = Lists.newArrayList();
        File wrapperPropertiesFile = GradleUtil.findWrapperPropertiesFile(project);
        if (wrapperPropertiesFile != null) {
            NotificationHyperlink hyperlink = FixGradleVersionInWrapperHyperlink.createIfProjectUsesGradleWrapper(project, gradleVersion);
            if (hyperlink != null) {
                hyperlinks.add(hyperlink);
            }
        } else {
            GradleProjectSettings gradleProjectSettings = GradleUtil.getGradleProjectSettings(project);
            if (gradleProjectSettings != null && gradleProjectSettings.getDistributionType() == DistributionType.LOCAL) {
                hyperlinks.add(new CreateGradleWrapperHyperlink());
            }
        }
        hyperlinks.add(new OpenGradleSettingsHyperlink());
        return hyperlinks;
    }
}

