/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.service.notification.errors;

import com.android.tools.idea.gradle.service.notification.errors.AbstractSyncErrorHandler;
import com.android.tools.idea.gradle.service.notification.hyperlink.BuildProjectHyperlink;
import com.android.tools.idea.gradle.service.notification.hyperlink.OpenAndroidSdkManagerHyperlink;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.service.notification.NotificationCategory;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.project.Project;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ObjectStreamErrorHandler
extends AbstractSyncErrorHandler {
    @Override
    public boolean handleError(@NotNull List<String> message, @NotNull ExternalSystemException error, @NotNull NotificationData notification, @NotNull Project project) {
        String firstLine = message.get(0);
        if (firstLine.endsWith("unexpected end of block data")) {
            BuildProjectHyperlink buildProjectHyperlink = new BuildProjectHyperlink();
            OpenAndroidSdkManagerHyperlink openAndroidSdkManagerHyperlink = new OpenAndroidSdkManagerHyperlink();
            String msg = "An unexpected I/O error occurred.\n";
            msg = msg + String.format("The error, \"%1$s\" usually happens on Linux when Build-tools or an Android platform being used in a project is not installed.\n", message);
            msg = msg + "Please try one of the following:<ul><li>" + buildProjectHyperlink.toHtml() + " to obtain the cause of the error</li>" + "<li>" + openAndroidSdkManagerHyperlink.toHtml() + " to check if there are any missing components</li></ul>";
            String title = String.format("Failed to sync Gradle project '%1$s'", project.getName());
            notification.setTitle(title);
            notification.setMessage(msg);
            notification.setNotificationCategory(NotificationCategory.convert((NotificationType)DEFAULT_NOTIFICATION_TYPE));
            ObjectStreamErrorHandler.addNotificationListener(notification, project, buildProjectHyperlink, openAndroidSdkManagerHyperlink);
            return true;
        }
        return false;
    }
}

