/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.service.notification.errors;

import com.android.tools.idea.gradle.project.GradleProjectImporter;
import com.android.tools.idea.gradle.service.notification.errors.AbstractSyncErrorHandler;
import com.android.tools.idea.gradle.service.notification.hyperlink.NotificationHyperlink;
import com.android.tools.idea.gradle.util.LocalProperties;
import com.android.tools.idea.sdk.SelectNdkDialog;
import com.google.common.collect.Lists;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NdkLocationNotFoundErrorHandler
extends AbstractSyncErrorHandler {
    private static final Logger LOG = Logger.getInstance(NdkLocationNotFoundErrorHandler.class);
    private static final String ERROR_TITLE = "Gradle Sync Error";

    @Override
    public boolean handleError(@NotNull List<String> message, @NotNull ExternalSystemException error, @NotNull NotificationData notification, @NotNull Project project) {
        String firstLine = message.get(0);
        if (firstLine.startsWith("NDK location not found.")) {
            ArrayList hyperlinks = Lists.newArrayList();
            NotificationHyperlink selectNdkLink = NdkLocationNotFoundErrorHandler.getSelectNdkNotificationHyperlink(true);
            hyperlinks.add(selectNdkLink);
            NdkLocationNotFoundErrorHandler.updateNotification(notification, project, "Android NDK location is not specified.", hyperlinks);
            return true;
        }
        return false;
    }

    public static NotificationHyperlink getSelectNdkNotificationHyperlink(final boolean showDownloadLink) {
        return new NotificationHyperlink("ndk.select", "Select NDK"){

            @Override
            protected void execute(@NotNull Project project) {
                File path = NdkLocationNotFoundErrorHandler.getNdkPath(project);
                SelectNdkDialog dialog = new SelectNdkDialog(path == null ? null : path.getPath(), false, showDownloadLink);
                dialog.setModal(true);
                if (dialog.showAndGet() && NdkLocationNotFoundErrorHandler.setNdkPath(project, dialog.getAndroidNdkPath())) {
                    GradleProjectImporter.getInstance().requestProjectSync(project, null);
                }
            }
        };
    }

    @Nullable
    private static File getNdkPath(@NotNull Project project) {
        try {
            return new LocalProperties(project).getAndroidNdkPath();
        }
        catch (IOException e) {
            String msg = String.format("Unable to read local.properties file of Project '%1$s'", project.getName());
            LOG.info(msg, (Throwable)e);
            return null;
        }
    }

    private static boolean setNdkPath(@NotNull Project project, @Nullable String ndkPath) {
        LocalProperties localProperties;
        try {
            localProperties = new LocalProperties(project);
        }
        catch (IOException e) {
            String msg = String.format("Unable to read local.properties file of Project '%1$s':\n%2$s", project.getName(), e.getMessage());
            Messages.showErrorDialog((String)msg, (String)ERROR_TITLE);
            return false;
        }
        try {
            localProperties.setAndroidNdkPath(ndkPath == null ? null : new File(ndkPath));
            localProperties.save();
        }
        catch (IOException e) {
            String msg = String.format("Unable to save local.properties file of Project '%1$s: %2$s", localProperties.getPropertiesFilePath().getPath(), e.getMessage());
            Messages.showErrorDialog((String)msg, (String)ERROR_TITLE);
            return false;
        }
        return true;
    }
}

