/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.service.notification.errors;

import com.android.tools.idea.gradle.service.notification.errors.AbstractSyncErrorHandler;
import com.android.tools.idea.gradle.service.notification.hyperlink.InstallBuildToolsHyperlink;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.project.Project;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class MissingBuildToolsErrorHandler
extends AbstractSyncErrorHandler {
    private static final Pattern MISSING_BUILD_TOOLS_PATTERN = Pattern.compile("(Cause: )?(F|f)ailed to find Build Tools revision (.*)");

    @Override
    public boolean handleError(@NotNull List<String> message, @NotNull ExternalSystemException error, @NotNull NotificationData notification, @NotNull Project project) {
        String firstLine = message.get(0);
        Matcher matcher = MISSING_BUILD_TOOLS_PATTERN.matcher(firstLine);
        if (matcher.matches()) {
            String version = matcher.group(3);
            InstallBuildToolsHyperlink hyperlink = new InstallBuildToolsHyperlink(version, null);
            MissingBuildToolsErrorHandler.updateNotification(notification, project, error.getMessage(), hyperlink);
            return true;
        }
        return false;
    }
}

