/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.service.notification.errors;

import com.android.tools.idea.gradle.service.notification.errors.AbstractSyncErrorHandler;
import com.android.tools.idea.gradle.service.notification.hyperlink.ToggleOfflineModeHyperlink;
import com.google.common.collect.Lists;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class InternetConnectionErrorHandler
extends AbstractSyncErrorHandler {
    @Override
    public boolean handleError(@NotNull List<String> message, @NotNull ExternalSystemException error, @NotNull NotificationData notification, @NotNull Project project) {
        String firstLine = message.get(0);
        if (InternetConnectionErrorHandler.isInternetConnectionError(firstLine)) {
            ArrayList hyperlinks = Lists.newArrayList();
            ToggleOfflineModeHyperlink enableOfflineMode = ToggleOfflineModeHyperlink.enableOfflineMode(project);
            if (enableOfflineMode != null) {
                hyperlinks.add(enableOfflineMode);
            }
            InternetConnectionErrorHandler.updateNotification(notification, project, error.getMessage(), hyperlinks);
            return true;
        }
        return false;
    }

    private static boolean isInternetConnectionError(@NotNull String msg) {
        return msg.startsWith("Could not GET ") || msg.startsWith("Could not HEAD ") || msg.startsWith("Network is unreachable");
    }
}

