/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.service.notification.errors;

import com.android.tools.idea.gradle.service.notification.errors.AbstractSyncErrorHandler;
import com.android.tools.idea.gradle.service.notification.hyperlink.OpenUrlHyperlink;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.project.Project;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GradleBrokenPipeErrorHandler
extends AbstractSyncErrorHandler {
    @Override
    public boolean handleError(@NotNull List<String> message, @NotNull ExternalSystemException error, @NotNull NotificationData notification, @NotNull Project project) {
        String firstLine = message.get(0);
        if (firstLine.startsWith("Broken pipe")) {
            String newMsg = "Broken pipe.\nThe Gradle daemon may be trying to use ipv4 instead of ipv6.";
            OpenUrlHyperlink hyperlink = new OpenUrlHyperlink("https://sites.google.com/a/android.com/tools/knownissues?pli=1#TOC-Gradle-Sync-Failed:-Broken-Pipe", "More info (including workarounds)");
            GradleBrokenPipeErrorHandler.updateNotification(notification, project, newMsg, hyperlink);
            return true;
        }
        return false;
    }
}

