/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.service.notification.errors;

import com.android.tools.idea.gradle.service.notification.errors.AbstractSyncErrorHandler;
import com.android.tools.idea.gradle.service.notification.hyperlink.ToggleOfflineModeHyperlink;
import com.google.common.collect.Lists;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CachedDependencyNotFoundErrorHandler
extends AbstractSyncErrorHandler {
    @Override
    public boolean handleError(@NotNull List<String> message, @NotNull ExternalSystemException error, @NotNull NotificationData notification, @NotNull Project project) {
        String firstLine = message.get(0);
        if (firstLine.startsWith("No cached version of ") && firstLine.contains("available for offline mode.")) {
            ArrayList hyperlinks = Lists.newArrayList();
            ToggleOfflineModeHyperlink disableOfflineMode = ToggleOfflineModeHyperlink.disableOfflineMode(project);
            if (disableOfflineMode != null) {
                hyperlinks.add(disableOfflineMode);
            }
            CachedDependencyNotFoundErrorHandler.updateNotification(notification, project, firstLine, hyperlinks);
            return true;
        }
        return false;
    }
}

